/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.network.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ItemData {
    private static final String[] EMPTY = new String[0];
    public static final ItemData AIR = new ItemData(0, 0, 0, null, EMPTY, EMPTY, 0L);
    private final int id;
    private final short damage;
    private final int count;
    private final CompoundTag tag;
    private final String[] canPlace;
    private final String[] canBreak;
    private final long blockingTicks;

    public static ItemData of(int id, short damage, int count) {
        return ItemData.of(id, damage, count, null);
    }

    public static ItemData of(int id, short damage, int count, CompoundTag tag) {
        return ItemData.of(id, damage, count, tag, EMPTY, EMPTY);
    }

    public static ItemData of(int id, short damage, int count, CompoundTag tag, String[] canPlace, String[] canBreak) {
        return ItemData.of(id, damage, count, tag, canPlace, canBreak, 0L);
    }

    public static ItemData of(int id, short damage, int count, CompoundTag tag, String[] canPlace, String[] canBreak, long blockingTicks) {
        if (id == 0) {
            return AIR;
        }
        Preconditions.checkNotNull((Object)canPlace, (Object)"canPlace");
        Preconditions.checkNotNull((Object)canBreak, (Object)"canBreak");
        Preconditions.checkArgument((count < 256 ? 1 : 0) != 0, (Object)"count exceeds maximum of 255");
        return new ItemData(id, damage, count, tag, canPlace, canBreak, blockingTicks);
    }

    public boolean isValid() {
        return !this.isNull() && this.id != 0;
    }

    public boolean isNull() {
        return this.count <= 0;
    }

    public boolean equals(ItemData other, boolean checkAmount, boolean checkMetadata, boolean checkUserdata) {
        return !(checkAmount && this.count != other.count || checkMetadata && this.damage != other.damage || checkUserdata && (!Objects.equals(this.tag, other.tag) || !Arrays.equals(this.canPlace, other.canPlace) || !Arrays.equals(this.canBreak, other.canBreak)));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemData)) {
            return false;
        }
        return this.equals((ItemData)obj, true, true, true);
    }

    public int getId() {
        return this.id;
    }

    public short getDamage() {
        return this.damage;
    }

    public int getCount() {
        return this.count;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public String[] getCanPlace() {
        return this.canPlace;
    }

    public String[] getCanBreak() {
        return this.canBreak;
    }

    public long getBlockingTicks() {
        return this.blockingTicks;
    }

    public String toString() {
        return "ItemData(id=" + this.getId() + ", damage=" + this.getDamage() + ", count=" + this.getCount() + ", tag=" + this.getTag() + ", canPlace=" + Arrays.deepToString(this.getCanPlace()) + ", canBreak=" + Arrays.deepToString(this.getCanBreak()) + ", blockingTicks=" + this.getBlockingTicks() + ")";
    }

    private ItemData(int id, short damage, int count, CompoundTag tag, String[] canPlace, String[] canBreak, long blockingTicks) {
        this.id = id;
        this.damage = damage;
        this.count = count;
        this.tag = tag;
        this.canPlace = canPlace;
        this.canBreak = canBreak;
        this.blockingTicks = blockingTicks;
    }
}

