/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.ContainerId;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;

public final class InventorySource {
    private static final InventorySource CREATIVE_SOURCE = new InventorySource(Type.CREATIVE, ContainerId.NONE, Flag.NONE);
    private static final InventorySource GLOBAL_SOURCE = new InventorySource(Type.GLOBAL, ContainerId.NONE, Flag.NONE);
    private static final InventorySource INVALID_SOURCE = new InventorySource(Type.INVALID, ContainerId.NONE, Flag.NONE);
    private final Type type;
    private final ContainerId containerId;
    private final Flag flag;

    public static InventorySource fromContainerWindowId(@Nonnull ContainerId containerId) {
        Preconditions.checkNotNull((Object)((Object)containerId), (Object)"containerId");
        return new InventorySource(Type.CONTAINER, containerId, Flag.NONE);
    }

    public static InventorySource fromCreativeInventory() {
        return CREATIVE_SOURCE;
    }

    public static InventorySource fromGlobalInventory() {
        return GLOBAL_SOURCE;
    }

    public static InventorySource fromInvalid() {
        return INVALID_SOURCE;
    }

    public static InventorySource fromNonImplementedTodo(@Nonnull ContainerId containerId) {
        Preconditions.checkNotNull((Object)((Object)containerId), (Object)"containerId");
        return new InventorySource(Type.NON_IMPLEMENTED_TODO, containerId, Flag.NONE);
    }

    public static InventorySource fromUntrackedInteractionUI(@Nonnull ContainerId containerId) {
        Preconditions.checkNotNull((Object)((Object)containerId), (Object)"containerId");
        return new InventorySource(Type.UNTRACKED_INTERACTION_UI, containerId, Flag.NONE);
    }

    public static InventorySource fromWorldInteraction(@Nonnull Flag flag) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        return new InventorySource(Type.WORLD_INTERACTION, ContainerId.NONE, flag);
    }

    public Type getType() {
        return this.type;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventorySource)) {
            return false;
        }
        InventorySource other = (InventorySource)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ContainerId this$containerId = this.getContainerId();
        ContainerId other$containerId = other.getContainerId();
        if (this$containerId == null ? other$containerId != null : !((Object)((Object)this$containerId)).equals((Object)other$containerId)) {
            return false;
        }
        Flag this$flag = this.getFlag();
        Flag other$flag = other.getFlag();
        return !(this$flag == null ? other$flag != null : !((Object)((Object)this$flag)).equals((Object)other$flag));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ContainerId $containerId = this.getContainerId();
        result = result * 59 + ($containerId == null ? 43 : ((Object)((Object)$containerId)).hashCode());
        Flag $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : ((Object)((Object)$flag)).hashCode());
        return result;
    }

    public String toString() {
        return "InventorySource(type=" + (Object)((Object)this.getType()) + ", containerId=" + (Object)((Object)this.getContainerId()) + ", flag=" + (Object)((Object)this.getFlag()) + ")";
    }

    private InventorySource(Type type, ContainerId containerId, Flag flag) {
        this.type = type;
        this.containerId = containerId;
        this.flag = flag;
    }

    public static enum Flag {
        DROP_ITEM,
        PICKUP_ITEM,
        NONE;

    }

    public static enum Type {
        INVALID(-1),
        CONTAINER(0),
        GLOBAL(1),
        WORLD_INTERACTION(2),
        CREATIVE(3),
        UNTRACKED_INTERACTION_UI(100),
        NON_IMPLEMENTED_TODO(99999);

        private static final TIntObjectMap<Type> BY_ID;
        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type byId(int id) {
            Type type = (Type)((Object)BY_ID.get(id));
            return type == null ? INVALID : type;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = new TIntObjectHashMap(6);
            for (Type type : Type.values()) {
                BY_ID.put(type.id, (Object)type);
            }
        }
    }
}

