/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.EntityData;
import com.nukkitx.protocol.bedrock.data.EntityFlags;
import com.nukkitx.protocol.bedrock.data.ItemData;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityDataDictionary
extends EnumMap<EntityData, Object> {
    public EntityDataDictionary() {
        super(EntityData.class);
    }

    private static boolean isAcceptable(Object o) {
        return o instanceof EntityFlags || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Float || o instanceof String || o instanceof ItemData || o instanceof CompoundTag || o instanceof Vector3i || o instanceof Long || o instanceof Vector3f;
    }

    @Nonnull
    public static EntityData.Type getType(Object o) {
        if (o instanceof EntityFlags) {
            return EntityData.Type.FLAGS;
        }
        if (o instanceof Byte) {
            return EntityData.Type.BYTE;
        }
        if (o instanceof Short) {
            return EntityData.Type.SHORT;
        }
        if (o instanceof Integer) {
            return EntityData.Type.INT;
        }
        if (o instanceof Float) {
            return EntityData.Type.FLOAT;
        }
        if (o instanceof String) {
            return EntityData.Type.STRING;
        }
        if (o instanceof ItemData || o instanceof CompoundTag) {
            return EntityData.Type.NBT;
        }
        if (o instanceof Vector3i) {
            return EntityData.Type.VECTOR3I;
        }
        if (o instanceof Long) {
            return EntityData.Type.LONG;
        }
        if (o instanceof Vector3f) {
            return EntityData.Type.VECTOR3F;
        }
        throw new IllegalArgumentException("Invalid type");
    }

    @Nullable
    public <T> T get(EntityData entityData) {
        return (T)super.get((Object)entityData);
    }

    public boolean contains(EntityData entityData) {
        return this.containsKey((Object)entityData);
    }

    @Nullable
    public EntityData.Type getType(EntityData entityData) {
        Object object = this.get(entityData);
        if (object == null) {
            return entityData.getType();
        }
        return EntityDataDictionary.getType(object);
    }

    @Override
    public Object put(@Nonnull EntityData entityData, @Nonnull Object o) {
        Preconditions.checkNotNull((Object)((Object)entityData), (Object)"dictionary");
        Preconditions.checkNotNull((Object)o, (Object)"o");
        Preconditions.checkArgument((boolean)EntityDataDictionary.isAcceptable(o), (String)"%s is an unacceptable metadata type", (Object)o.getClass().getSimpleName());
        if (entityData == EntityData.FLAGS || entityData == EntityData.FLAGS_2) {
            Preconditions.checkArgument((EntityDataDictionary.getType(o) == EntityData.Type.FLAGS ? 1 : 0) != 0, (Object)"Invalid class for flags");
            this.putFlags((EntityFlags)o);
            return null;
        }
        return super.put(entityData, o);
    }

    public EntityFlags getFlags() {
        return (EntityFlags)this.get(EntityData.FLAGS);
    }

    public void putFlags(@Nonnull EntityFlags flags) {
        EntityFlags originalFlags = (EntityFlags)this.get(EntityData.FLAGS);
        if (originalFlags != null) {
            originalFlags.merge(flags);
        } else {
            super.put(EntityData.FLAGS, flags);
            super.put(EntityData.FLAGS_2, flags);
        }
    }
}

