/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.nukkitx.protocol.bedrock.data.CraftingType;
import com.nukkitx.protocol.bedrock.data.ItemData;
import java.util.Arrays;
import java.util.UUID;

public final class CraftingData {
    private final CraftingType type;
    private final String recipeId;
    private final int width;
    private final int height;
    private final int inputId;
    private final int inputDamage;
    private final ItemData[] inputs;
    private final ItemData[] outputs;
    private final UUID uuid;
    private final String craftingTag;
    private final int priority;

    public CraftingData(CraftingType type, int width, int height, int inputId, int inputDamage, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        this.type = type;
        this.recipeId = null;
        this.width = width;
        this.height = height;
        this.inputId = inputId;
        this.inputDamage = inputDamage;
        this.inputs = inputs;
        this.outputs = outputs;
        this.uuid = uuid;
        this.craftingTag = craftingTag;
        this.priority = 0;
    }

    public static CraftingData fromFurnaceData(int inputId, int inputDamage, ItemData input, String craftingTag) {
        return new CraftingData(CraftingType.FURNACE_DATA, null, -1, -1, inputId, inputDamage, new ItemData[]{input}, null, null, craftingTag, -1);
    }

    public static CraftingData fromFurnace(int inputId, ItemData input, String craftingTag) {
        return new CraftingData(CraftingType.FURNACE, null, -1, -1, inputId, -1, new ItemData[]{input}, null, null, craftingTag, -1);
    }

    public static CraftingData fromShapeless(String recipeId, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag, int priority) {
        return new CraftingData(CraftingType.SHAPELESS, recipeId, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, priority);
    }

    public static CraftingData fromShaped(String recipeId, int width, int height, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag, int priority) {
        return new CraftingData(CraftingType.SHAPED, recipeId, width, height, -1, -1, inputs, outputs, uuid, craftingTag, priority);
    }

    public static CraftingData fromShapelessChemistry(String recipeId, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag, int priority) {
        return new CraftingData(CraftingType.SHAPELESS_CHEMISTRY, recipeId, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, priority);
    }

    public static CraftingData fromShapedChemistry(String recipeId, int width, int height, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag, int priority) {
        return new CraftingData(CraftingType.SHAPED_CHEMISTRY, recipeId, width, height, -1, -1, inputs, outputs, uuid, craftingTag, priority);
    }

    public static CraftingData fromShulkerBox(String recipeId, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag, int priority) {
        return new CraftingData(CraftingType.SHULKER_BOX, recipeId, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, priority);
    }

    public static CraftingData fromMulti(UUID uuid) {
        return new CraftingData(CraftingType.MULTI, null, -1, -1, -1, -1, null, null, uuid, null, -1);
    }

    public static CraftingData fromShapeless(ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPELESS, "", -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, 0);
    }

    public static CraftingData fromShaped(int width, int height, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPED, "", width, height, -1, -1, inputs, outputs, uuid, craftingTag, 0);
    }

    public static CraftingData fromShapelessChemistry(ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPELESS_CHEMISTRY, "", -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, 0);
    }

    public static CraftingData fromShapedChemistry(int width, int height, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPED_CHEMISTRY, "", width, height, -1, -1, inputs, outputs, uuid, craftingTag, 0);
    }

    public static CraftingData fromShulkerBox(ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHULKER_BOX, "", -1, -1, -1, -1, inputs, outputs, uuid, craftingTag, 0);
    }

    public CraftingType getType() {
        return this.type;
    }

    public String getRecipeId() {
        return this.recipeId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getInputId() {
        return this.inputId;
    }

    public int getInputDamage() {
        return this.inputDamage;
    }

    public ItemData[] getInputs() {
        return this.inputs;
    }

    public ItemData[] getOutputs() {
        return this.outputs;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getCraftingTag() {
        return this.craftingTag;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftingData)) {
            return false;
        }
        CraftingData other = (CraftingData)o;
        CraftingType this$type = this.getType();
        CraftingType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$recipeId = this.getRecipeId();
        String other$recipeId = other.getRecipeId();
        if (this$recipeId == null ? other$recipeId != null : !this$recipeId.equals(other$recipeId)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getInputId() != other.getInputId()) {
            return false;
        }
        if (this.getInputDamage() != other.getInputDamage()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOutputs(), other.getOutputs())) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$craftingTag = this.getCraftingTag();
        String other$craftingTag = other.getCraftingTag();
        if (this$craftingTag == null ? other$craftingTag != null : !this$craftingTag.equals(other$craftingTag)) {
            return false;
        }
        return this.getPriority() == other.getPriority();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CraftingType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $recipeId = this.getRecipeId();
        result = result * 59 + ($recipeId == null ? 43 : $recipeId.hashCode());
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getInputId();
        result = result * 59 + this.getInputDamage();
        result = result * 59 + Arrays.deepHashCode(this.getInputs());
        result = result * 59 + Arrays.deepHashCode(this.getOutputs());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $craftingTag = this.getCraftingTag();
        result = result * 59 + ($craftingTag == null ? 43 : $craftingTag.hashCode());
        result = result * 59 + this.getPriority();
        return result;
    }

    public String toString() {
        return "CraftingData(type=" + (Object)((Object)this.getType()) + ", recipeId=" + this.getRecipeId() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", inputId=" + this.getInputId() + ", inputDamage=" + this.getInputDamage() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ", outputs=" + Arrays.deepToString(this.getOutputs()) + ", uuid=" + this.getUuid() + ", craftingTag=" + this.getCraftingTag() + ", priority=" + this.getPriority() + ")";
    }

    public CraftingData(CraftingType type, String recipeId, int width, int height, int inputId, int inputDamage, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag, int priority) {
        this.type = type;
        this.recipeId = recipeId;
        this.width = width;
        this.height = height;
        this.inputId = inputId;
        this.inputDamage = inputDamage;
        this.inputs = inputs;
        this.outputs = outputs;
        this.uuid = uuid;
        this.craftingTag = craftingTag;
        this.priority = priority;
    }
}

