/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public enum ContainerType {
    UNTRACKED_UI_INTERACTION(-9),
    INVENTORY(-1),
    CONTAINER(0),
    WORKBENCH(1),
    FURNACE(2),
    ENCHANTMENT(3),
    BREWING_STAND(4),
    ANVIL(5),
    DISPENSER(6),
    DROPPER(7),
    HOPPER(8),
    CAULDRON(9),
    CHEST(10),
    MINECART_HOPPER(11),
    HORSE(12),
    BEACON(13),
    STRUCTURE_EDITOR(14),
    TRADING(15),
    COMMAND_BLOCK(16),
    JUKEBOX(17),
    COMPOUND_CREATOR(20),
    ELEMENT_CONSTRUCTOR(21),
    MATERIAL_REDUCER(22),
    LAB_TABLE(23);

    public static final TIntObjectMap<ContainerType> BY_ID;
    private final int id;

    private ContainerType(int id) {
        this.id = id;
    }

    public static ContainerType fromId(int id) {
        return (ContainerType)((Object)BY_ID.get(id));
    }

    public int id() {
        return this.id;
    }

    static {
        BY_ID = new TIntObjectHashMap();
        for (ContainerType type : ContainerType.values()) {
            BY_ID.put(type.id, (Object)type);
        }
    }
}

