/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.compressionhandler;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.compressionhandler.BedrockCompressionHandler;
import com.nukkitx.protocol.bedrock.exception.PacketSerializeException;
import com.nukkitx.protocol.util.Zlib;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.DataFormatException;

public class DefaultBedrockCompressionHandler
implements BedrockCompressionHandler {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(DefaultBedrockCompressionHandler.class);
    public static final DefaultBedrockCompressionHandler DEFAULT = new DefaultBedrockCompressionHandler();
    private final Zlib zlib;

    private DefaultBedrockCompressionHandler() {
        this.zlib = Zlib.DEFAULT;
    }

    public DefaultBedrockCompressionHandler(int compression) {
        this.zlib = new Zlib(compression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf compressPackets(BedrockPacketCodec packetCodec, Collection<BedrockPacket> packets) {
        ByteBuf source = PooledByteBufAllocator.DEFAULT.directBuffer();
        try {
            for (BedrockPacket packet : packets) {
                ByteBuf packetBuf = null;
                try {
                    packetBuf = packetCodec.tryEncode(packet);
                    VarInts.writeUnsignedInt((ByteBuf)source, (long)packetBuf.readableBytes());
                    source.writeBytes(packetBuf);
                }
                catch (PacketSerializeException e) {
                    log.debug("Error occurred whilst encoding " + packet.getClass().getSimpleName(), (Throwable)e);
                }
                finally {
                    if (packetBuf == null) continue;
                    packetBuf.release();
                }
            }
            ByteBuf byteBuf = this.zlib.deflate(source);
            return byteBuf;
        }
        catch (DataFormatException e) {
            throw new RuntimeException("Unable to deflate buffer data", e);
        }
        finally {
            source.release();
        }
    }

    public List<BedrockPacket> decompressPackets(BedrockPacketCodec packetCodec, ByteBuf compressed) {
        ArrayList<BedrockPacket> packets = new ArrayList<BedrockPacket>();
        ByteBuf decompressed = null;
        try {
            decompressed = this.zlib.inflate(compressed);
            while (decompressed.isReadable()) {
                int length = VarInts.readUnsignedInt((ByteBuf)decompressed);
                ByteBuf data = decompressed.readSlice(length);
                if (!data.isReadable()) {
                    throw new DataFormatException("Contained packet is empty.");
                }
                try {
                    BedrockPacket pkg = packetCodec.tryDecode(data);
                    packets.add(pkg);
                }
                catch (PacketSerializeException e) {
                    log.debug("Error occurred whilst decoding packet", (Throwable)e);
                    log.trace("Packet contents\n{}", (Object)ByteBufUtil.prettyHexDump((ByteBuf)data.readerIndex(0)));
                }
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeException("Unable to inflate buffer data", e);
        }
        finally {
            if (decompressed != null) {
                decompressed.release();
            }
        }
        return packets;
    }
}

