/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetServer;
import com.nukkitx.network.raknet.RakNetServerListener;
import com.nukkitx.network.raknet.RakNetServerSession;
import com.nukkitx.network.raknet.RakNetSession;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.util.EventLoops;
import com.nukkitx.protocol.bedrock.Bedrock;
import com.nukkitx.protocol.bedrock.BedrockPong;
import com.nukkitx.protocol.bedrock.BedrockRakNetSessionListener;
import com.nukkitx.protocol.bedrock.BedrockServerEventHandler;
import com.nukkitx.protocol.bedrock.BedrockServerSession;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public class BedrockServer
extends Bedrock {
    private final RakNetServer rakNetServer;
    final Set<BedrockServerSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private BedrockServerEventHandler handler;

    public BedrockServer(InetSocketAddress bindAddress) {
        this(bindAddress, 1);
    }

    public BedrockServer(InetSocketAddress bindAddress, int maxThreads) {
        this(bindAddress, maxThreads, EventLoops.commonGroup());
    }

    public BedrockServer(InetSocketAddress bindAddress, int maxThreads, EventLoopGroup eventLoopGroup) {
        super(eventLoopGroup);
        this.rakNetServer = new RakNetServer(bindAddress, maxThreads, eventLoopGroup);
        this.rakNetServer.setProtocolVersion(-1);
        this.rakNetServer.setListener((RakNetServerListener)new BedrockServerListener());
    }

    public BedrockServerEventHandler getHandler() {
        return this.handler;
    }

    public void setHandler(BedrockServerEventHandler handler) {
        this.handler = handler;
    }

    @Override
    RakNet getRakNet() {
        return this.rakNetServer;
    }

    @Override
    public void close() {
        this.close("disconnect.disconnected");
    }

    public void close(String reason) {
        for (BedrockServerSession session : this.sessions) {
            session.disconnect(reason);
        }
        this.rakNetServer.close();
    }

    public boolean isClosed() {
        return this.rakNetServer.isClosed();
    }

    @Override
    protected void onTick() {
        for (BedrockServerSession session : this.sessions) {
            this.eventLoopGroup.execute(session::onTick);
        }
    }

    @ParametersAreNonnullByDefault
    private class BedrockServerListener
    implements RakNetServerListener {
        private BedrockServerListener() {
        }

        public boolean onConnectionRequest(InetSocketAddress address) {
            return BedrockServer.this.handler == null || BedrockServer.this.handler.onConnectionRequest(address);
        }

        @Nullable
        public byte[] onQuery(InetSocketAddress address) {
            BedrockPong pong;
            if (BedrockServer.this.handler != null && (pong = BedrockServer.this.handler.onQuery(address)) != null) {
                pong.setServerId(BedrockServer.this.rakNetServer.getGuid());
                return pong.toRakNet();
            }
            return null;
        }

        public void onSessionCreation(RakNetServerSession connection) {
            BedrockServerSession session = new BedrockServerSession((RakNetSession)connection);
            connection.setListener((RakNetSessionListener)new BedrockRakNetSessionListener.Server(session, (RakNetSession)connection, BedrockServer.this));
        }

        public void onUnhandledDatagram(ChannelHandlerContext ctx, DatagramPacket packet) {
        }
    }
}

