/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.MinecraftPacket;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.exception.PacketSerializeException;
import com.nukkitx.protocol.bedrock.packet.PacketHeader;
import com.nukkitx.protocol.bedrock.packet.UnknownPacket;
import com.nukkitx.protocol.serializer.PacketSerializer;
import com.nukkitx.protocol.util.TIntHashBiMap;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BedrockPacketCodec {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockPacketCodec.class);
    private final int protocolVersion;
    private final String minecraftVersion;
    private final PacketSerializer<BedrockPacket>[] serializers;
    private final TIntHashBiMap<Class<BedrockPacket>> idBiMap;
    private final PacketSerializer<PacketHeader> headerSerializer;

    public static Builder builder() {
        return new Builder();
    }

    public BedrockPacket tryDecode(ByteBuf buf) throws PacketSerializeException {
        BedrockPacket packet;
        PacketHeader header = new PacketHeader();
        this.headerSerializer.deserialize(buf, (MinecraftPacket)header);
        try {
            packet = (BedrockPacket)((Class)this.idBiMap.get(header.getPacketId())).newInstance();
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        packet.setHeader(header);
        try {
            this.serializers[header.getPacketId()].deserialize(buf, (MinecraftPacket)packet);
        }
        catch (Exception e) {
            throw new PacketSerializeException("Error whilst deserializing " + packet.getClass().getSimpleName(), e);
        }
        if (log.isDebugEnabled() && buf.isReadable()) {
            log.debug(packet.getClass().getSimpleName() + " still has " + buf.readableBytes() + " bytes to read!");
        }
        return packet;
    }

    public ByteBuf tryEncode(BedrockPacket packet) throws PacketSerializeException {
        PacketHeader header = packet.getHeader();
        if (header == null) {
            header = new PacketHeader();
        }
        int packetId = this.getId(packet);
        header.setPacketId(packetId);
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.directBuffer();
        try {
            this.headerSerializer.serialize(buf, (MinecraftPacket)header);
            this.serializers[packetId].serialize(buf, (MinecraftPacket)packet);
        }
        catch (Exception e) {
            throw new PacketSerializeException("Error whilst serializing " + packet.getClass().getSimpleName(), e);
        }
        return buf;
    }

    public int getId(BedrockPacket packet) {
        Class<?> clazz = packet.getClass();
        int id = this.idBiMap.get(clazz);
        if (id == -1) {
            throw new IllegalArgumentException("Packet ID for " + clazz.getName() + " does not exist.");
        }
        return id;
    }

    public BedrockPacketCodec(int protocolVersion, String minecraftVersion, PacketSerializer<BedrockPacket>[] serializers, TIntHashBiMap<Class<BedrockPacket>> idBiMap, PacketSerializer<PacketHeader> headerSerializer) {
        this.protocolVersion = protocolVersion;
        this.minecraftVersion = minecraftVersion;
        this.serializers = serializers;
        this.idBiMap = idBiMap;
        this.headerSerializer = headerSerializer;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public static class Builder {
        private final TIntObjectMap<PacketSerializer<BedrockPacket>> serializers = new TIntObjectHashMap();
        private final TIntHashBiMap<Class<BedrockPacket>> idBiMap = new TIntHashBiMap(UnknownPacket.class);
        private int protocolVersion = -1;
        private String minecraftVersion = null;
        private PacketSerializer<PacketHeader> headerSerializer = null;

        public <T extends BedrockPacket> Builder registerPacket(Class<T> packetClass, PacketSerializer<T> packetSerializer, @Nonnegative int id) {
            Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id cannot be negative");
            Class<T> clazz = packetClass;
            PacketSerializer<T> serializer = packetSerializer;
            Preconditions.checkArgument((!this.idBiMap.containsKey(id) ? 1 : 0) != 0, (Object)"Packet id already registered");
            Preconditions.checkArgument((!this.idBiMap.containsValue(clazz) ? 1 : 0) != 0, (Object)"Packet class already registered");
            this.serializers.put(id, serializer);
            this.idBiMap.put(id, clazz);
            return this;
        }

        public Builder protocolVersion(@Nonnegative int protocolVersion) {
            Preconditions.checkArgument((protocolVersion >= 0 ? 1 : 0) != 0, (Object)"protocolVersion cannot be negative");
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder minecraftVersion(@Nonnull String minecraftVersion) {
            Preconditions.checkNotNull((Object)minecraftVersion, (Object)"minecraftVersion");
            Preconditions.checkArgument((!minecraftVersion.isEmpty() && minecraftVersion.split("\\.").length > 2 ? 1 : 0) != 0, (Object)"Invalid minecraftVersion");
            this.minecraftVersion = minecraftVersion;
            return this;
        }

        public Builder headerSerializer(@Nonnull PacketSerializer<PacketHeader> headerSerializer) {
            Preconditions.checkNotNull(headerSerializer, (Object)"headerFactory");
            this.headerSerializer = headerSerializer;
            return this;
        }

        public BedrockPacketCodec build() {
            Preconditions.checkArgument((this.protocolVersion >= 0 ? 1 : 0) != 0, (Object)"No protocol version defined");
            Preconditions.checkNotNull((Object)this.minecraftVersion, (Object)"No Minecraft version defined");
            Preconditions.checkNotNull(this.headerSerializer, (Object)"headerSerializer cannot be null");
            int largestId = -1;
            for (int id : this.serializers.keys()) {
                if (id <= largestId) continue;
                largestId = id;
            }
            Preconditions.checkArgument((largestId > -1 ? 1 : 0) != 0, (Object)"Must have at least one packet registered");
            PacketSerializer[] serializers = new PacketSerializer[largestId + 1];
            TIntObjectIterator iterator = this.serializers.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                serializers[iterator.key()] = (PacketSerializer)iterator.value();
            }
            return new BedrockPacketCodec(this.protocolVersion, this.minecraftVersion, serializers, this.idBiMap, this.headerSerializer);
        }

        private Builder() {
        }
    }
}

