/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetClient;
import com.nukkitx.network.raknet.RakNetClientSession;
import com.nukkitx.network.raknet.RakNetSession;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.util.EventLoops;
import com.nukkitx.protocol.bedrock.Bedrock;
import com.nukkitx.protocol.bedrock.BedrockClientSession;
import com.nukkitx.protocol.bedrock.BedrockPong;
import com.nukkitx.protocol.bedrock.BedrockRakNetSessionListener;
import io.netty.channel.EventLoopGroup;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class BedrockClient
extends Bedrock {
    private final RakNetClient rakNetClient;
    BedrockClientSession session;

    public BedrockClient(InetSocketAddress bindAddress) {
        this(bindAddress, EventLoops.commonGroup());
    }

    public BedrockClient(InetSocketAddress bindAddress, EventLoopGroup eventLoopGroup) {
        super(eventLoopGroup);
        this.rakNetClient = new RakNetClient(bindAddress, eventLoopGroup);
    }

    @Override
    protected void onTick() {
        if (this.session != null) {
            this.eventLoopGroup.execute(this.session::onTick);
        }
    }

    @Override
    RakNet getRakNet() {
        return this.rakNetClient;
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
        }
        this.rakNetClient.close();
    }

    public CompletableFuture<BedrockClientSession> connect(InetSocketAddress address) {
        CompletableFuture<BedrockClientSession> future = new CompletableFuture<BedrockClientSession>();
        this.ping(address).whenComplete((pong, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            int port = address.getAddress() instanceof Inet4Address && pong.getIpv4Port() != -1 ? pong.getIpv4Port() : (address.getAddress() instanceof Inet6Address && pong.getIpv6Port() != -1 ? pong.getIpv6Port() : address.getPort());
            InetSocketAddress connectAddress = new InetSocketAddress(address.getAddress(), port);
            RakNetClientSession connection = this.rakNetClient.create(connectAddress);
            this.session = new BedrockClientSession((RakNetSession)connection);
            BedrockRakNetSessionListener.Client listener = new BedrockRakNetSessionListener.Client(this.session, (RakNetSession)connection, this, future);
            connection.setListener((RakNetSessionListener)listener);
            connection.connect();
        });
        return future;
    }

    public CompletableFuture<BedrockPong> ping(InetSocketAddress address) {
        return this.rakNetClient.ping(address, 10L, TimeUnit.SECONDS).thenApply(BedrockPong::fromRakNet);
    }

    public BedrockClientSession getSession() {
        return this.session;
    }
}

