/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import com.nukkitx.protocol.serializer.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;

public final class UnknownPacket
extends BedrockPacket
implements PacketSerializer<UnknownPacket> {
    private ByteBuf payload;

    public void serialize(ByteBuf buffer, UnknownPacket packet) {
        buffer.writeBytes(packet.payload);
    }

    public void deserialize(ByteBuf buffer, UnknownPacket packet) {
        packet.payload = buffer.readBytes(buffer.readableBytes());
    }

    public String toString() {
        return "UNKNOWN - " + this.getHeader() + " - Hex: " + ByteBufUtil.hexDump((ByteBuf)this.payload);
    }

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return false;
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnknownPacket)) {
            return false;
        }
        UnknownPacket other = (UnknownPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteBuf this$payload = this.getPayload();
        ByteBuf other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnknownPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ByteBuf $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }
}

