/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;

public class BossEventPacket
extends BedrockPacket {
    private long bossUniqueEntityId;
    private Type type;
    private long playerUniqueEntityId;
    private String title;
    private float healthPercentage;
    private int darkenSky;
    private int color;
    private int overlay;

    @Override
    public final boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    public long getBossUniqueEntityId() {
        return this.bossUniqueEntityId;
    }

    public Type getType() {
        return this.type;
    }

    public long getPlayerUniqueEntityId() {
        return this.playerUniqueEntityId;
    }

    public String getTitle() {
        return this.title;
    }

    public float getHealthPercentage() {
        return this.healthPercentage;
    }

    public int getDarkenSky() {
        return this.darkenSky;
    }

    public int getColor() {
        return this.color;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public void setBossUniqueEntityId(long bossUniqueEntityId) {
        this.bossUniqueEntityId = bossUniqueEntityId;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setPlayerUniqueEntityId(long playerUniqueEntityId) {
        this.playerUniqueEntityId = playerUniqueEntityId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setHealthPercentage(float healthPercentage) {
        this.healthPercentage = healthPercentage;
    }

    public void setDarkenSky(int darkenSky) {
        this.darkenSky = darkenSky;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setOverlay(int overlay) {
        this.overlay = overlay;
    }

    public String toString() {
        return "BossEventPacket(bossUniqueEntityId=" + this.getBossUniqueEntityId() + ", type=" + (Object)((Object)this.getType()) + ", playerUniqueEntityId=" + this.getPlayerUniqueEntityId() + ", title=" + this.getTitle() + ", healthPercentage=" + this.getHealthPercentage() + ", darkenSky=" + this.getDarkenSky() + ", color=" + this.getColor() + ", overlay=" + this.getOverlay() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BossEventPacket)) {
            return false;
        }
        BossEventPacket other = (BossEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBossUniqueEntityId() != other.getBossUniqueEntityId()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.getPlayerUniqueEntityId() != other.getPlayerUniqueEntityId()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (Float.compare(this.getHealthPercentage(), other.getHealthPercentage()) != 0) {
            return false;
        }
        if (this.getDarkenSky() != other.getDarkenSky()) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        return this.getOverlay() == other.getOverlay();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BossEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $bossUniqueEntityId = this.getBossUniqueEntityId();
        result = result * 59 + (int)($bossUniqueEntityId >>> 32 ^ $bossUniqueEntityId);
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        long $playerUniqueEntityId = this.getPlayerUniqueEntityId();
        result = result * 59 + (int)($playerUniqueEntityId >>> 32 ^ $playerUniqueEntityId);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getHealthPercentage());
        result = result * 59 + this.getDarkenSky();
        result = result * 59 + this.getColor();
        result = result * 59 + this.getOverlay();
        return result;
    }

    public static enum Type {
        SHOW,
        REGISTER_PLAYER,
        HIDE,
        UNREGISTER_PLAYER,
        HEALTH_PERCENTAGE,
        TITLE,
        DARKEN_SKY,
        OVERLAY;

    }
}

