/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

public final class EntityLink {
    private final long from;
    private final long to;
    private final Type type;
    private final boolean immediate;

    public EntityLink(long from, long to, Type type, boolean immediate) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.immediate = immediate;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityLink)) {
            return false;
        }
        EntityLink other = (EntityLink)o;
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getTo() != other.getTo()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return this.isImmediate() == other.isImmediate();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $from = this.getFrom();
        result = result * 59 + (int)($from >>> 32 ^ $from);
        long $to = this.getTo();
        result = result * 59 + (int)($to >>> 32 ^ $to);
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + (this.isImmediate() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "EntityLink(from=" + this.getFrom() + ", to=" + this.getTo() + ", type=" + (Object)((Object)this.getType()) + ", immediate=" + this.isImmediate() + ")";
    }

    public static enum Type {
        REMOVE,
        RIDER,
        PASSENGER;

    }
}

