/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.data.EntityFlag;
import com.nukkitx.protocol.util.TIntHashBiMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class EntityFlags {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EntityFlags.class);
    private final Set<EntityFlag> flags = new HashSet<EntityFlag>();

    public static EntityFlags create(long value, int index, TIntHashBiMap<EntityFlag> flagMappings) {
        EntityFlags flags = new EntityFlags();
        int lower = index * 64;
        int upper = lower + 64;
        for (int i = lower; i < upper; ++i) {
            int idx = i & 0x3F;
            if ((value & 1L << idx) == 0L) continue;
            EntityFlag flag = (EntityFlag)((Object)flagMappings.get(i));
            if (flag != null) {
                flags.flags.add(flag);
                continue;
            }
            log.debug("Unknown Metadata flag index {} detected", (Object)i);
        }
        return flags;
    }

    public boolean setFlag(@Nonnull EntityFlag flag, boolean value) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        boolean contains = this.flags.contains((Object)flag);
        if (contains && !value) {
            this.flags.remove((Object)flag);
            return true;
        }
        if (!contains && value) {
            this.flags.add(flag);
            return true;
        }
        return false;
    }

    public boolean getFlag(@Nonnull EntityFlag flag) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        return this.flags.contains((Object)flag);
    }

    public long get(int index, TIntHashBiMap<EntityFlag> flagMappings) {
        long value = 0L;
        int lower = index * 64;
        int upper = lower + 64;
        for (EntityFlag flag : this.flags) {
            int flagIndex = flagMappings.get((Object)flag);
            if (flagIndex < lower || flagIndex >= upper) continue;
            value |= 1L << (flagIndex & 0x3F);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityFlags)) {
            return false;
        }
        EntityFlags that = (EntityFlags)o;
        return Objects.equals(this.flags, that.flags);
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public void merge(EntityFlags flags) {
        this.flags.addAll(flags.flags);
    }

    public EntityFlags copy() {
        EntityFlags flags = new EntityFlags();
        flags.flags.addAll(this.flags);
        return flags;
    }

    public String toString() {
        return "EntityFlags(flags=" + this.flags + ")";
    }
}

