/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.nukkitx.protocol.bedrock.data.CraftingType;
import com.nukkitx.protocol.bedrock.data.ItemData;
import java.util.Arrays;
import java.util.UUID;

public final class CraftingData {
    private final CraftingType type;
    private final int width;
    private final int height;
    private final int inputId;
    private final int inputDamage;
    private final ItemData[] inputs;
    private final ItemData[] outputs;
    private final UUID uuid;
    private final String craftingTag;

    public static CraftingData fromFurnaceData(int inputId, int inputDamage, ItemData input, String craftingTag) {
        return new CraftingData(CraftingType.FURNACE_DATA, -1, -1, inputId, inputDamage, new ItemData[]{input}, null, null, craftingTag);
    }

    public static CraftingData fromFurnace(int inputId, ItemData input, String craftingTag) {
        return new CraftingData(CraftingType.FURNACE, -1, -1, inputId, -1, new ItemData[]{input}, null, null, craftingTag);
    }

    public static CraftingData fromShapeless(ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPELESS, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag);
    }

    public static CraftingData fromShaped(int width, int height, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPED, width, height, -1, -1, inputs, outputs, uuid, craftingTag);
    }

    public static CraftingData fromShapelessChemistry(ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPELESS_CHEMISTRY, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag);
    }

    public static CraftingData fromShapedChemistry(int width, int height, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHAPED_CHEMISTRY, width, height, -1, -1, inputs, outputs, uuid, craftingTag);
    }

    public static CraftingData fromShulkerBox(ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        return new CraftingData(CraftingType.SHULKER_BOX, -1, -1, -1, -1, inputs, outputs, uuid, craftingTag);
    }

    public static CraftingData fromMulti(UUID uuid) {
        return new CraftingData(CraftingType.MULTI, -1, -1, -1, -1, null, null, uuid, null);
    }

    public CraftingData(CraftingType type, int width, int height, int inputId, int inputDamage, ItemData[] inputs, ItemData[] outputs, UUID uuid, String craftingTag) {
        this.type = type;
        this.width = width;
        this.height = height;
        this.inputId = inputId;
        this.inputDamage = inputDamage;
        this.inputs = inputs;
        this.outputs = outputs;
        this.uuid = uuid;
        this.craftingTag = craftingTag;
    }

    public CraftingType getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getInputId() {
        return this.inputId;
    }

    public int getInputDamage() {
        return this.inputDamage;
    }

    public ItemData[] getInputs() {
        return this.inputs;
    }

    public ItemData[] getOutputs() {
        return this.outputs;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getCraftingTag() {
        return this.craftingTag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftingData)) {
            return false;
        }
        CraftingData other = (CraftingData)o;
        CraftingType this$type = this.getType();
        CraftingType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getInputId() != other.getInputId()) {
            return false;
        }
        if (this.getInputDamage() != other.getInputDamage()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOutputs(), other.getOutputs())) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$craftingTag = this.getCraftingTag();
        String other$craftingTag = other.getCraftingTag();
        return !(this$craftingTag == null ? other$craftingTag != null : !this$craftingTag.equals(other$craftingTag));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CraftingType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getInputId();
        result = result * 59 + this.getInputDamage();
        result = result * 59 + Arrays.deepHashCode(this.getInputs());
        result = result * 59 + Arrays.deepHashCode(this.getOutputs());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $craftingTag = this.getCraftingTag();
        result = result * 59 + ($craftingTag == null ? 43 : $craftingTag.hashCode());
        return result;
    }

    public String toString() {
        return "CraftingData(type=" + (Object)((Object)this.getType()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", inputId=" + this.getInputId() + ", inputDamage=" + this.getInputDamage() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ", outputs=" + Arrays.deepToString(this.getOutputs()) + ", uuid=" + this.getUuid() + ", craftingTag=" + this.getCraftingTag() + ")";
    }
}

