/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.data;

import com.nukkitx.protocol.bedrock.data.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.CommandParamType;
import java.util.List;
import lombok.NonNull;

public final class CommandParamData {
    @NonNull
    private final String name;
    private final boolean optional;
    private final CommandEnumData enumData;
    private final Type type;
    private final String postfix;
    private final List<Option> options;

    public CommandParamData(@NonNull String name, boolean optional, CommandEnumData enumData, Type type, String postfix, List<Option> options) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.optional = optional;
        this.enumData = enumData;
        this.type = type;
        this.postfix = postfix;
        this.options = options;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public CommandEnumData getEnumData() {
        return this.enumData;
    }

    public Type getType() {
        return this.type;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandParamData)) {
            return false;
        }
        CommandParamData other = (CommandParamData)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        CommandEnumData this$enumData = this.getEnumData();
        CommandEnumData other$enumData = other.getEnumData();
        if (this$enumData == null ? other$enumData != null : !this$enumData.equals(other$enumData)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$postfix = this.getPostfix();
        String other$postfix = other.getPostfix();
        if (this$postfix == null ? other$postfix != null : !this$postfix.equals(other$postfix)) {
            return false;
        }
        List<Option> this$options = this.getOptions();
        List<Option> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isOptional() ? 79 : 97);
        CommandEnumData $enumData = this.getEnumData();
        result = result * 59 + ($enumData == null ? 43 : ((Object)$enumData).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $postfix = this.getPostfix();
        result = result * 59 + ($postfix == null ? 43 : $postfix.hashCode());
        List<Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "CommandParamData(name=" + this.getName() + ", optional=" + this.isOptional() + ", enumData=" + this.getEnumData() + ", type=" + (Object)((Object)this.getType()) + ", postfix=" + this.getPostfix() + ", options=" + this.getOptions() + ")";
    }

    public static final class Builder {
        private final String name;
        private final CommandParamType type;
        private final boolean optional;
        private final byte options;

        public Builder(String name, CommandParamType type, boolean optional) {
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.options = 0;
        }

        public String getName() {
            return this.name;
        }

        public CommandParamType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public byte getOptions() {
            return this.options;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            CommandParamType this$type = this.getType();
            CommandParamType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            return this.getOptions() == other.getOptions();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            CommandParamType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            result = result * 59 + (this.isOptional() ? 79 : 97);
            result = result * 59 + this.getOptions();
            return result;
        }

        public String toString() {
            return "CommandParamData.Builder(name=" + this.getName() + ", type=" + this.getType() + ", optional=" + this.isOptional() + ", options=" + this.getOptions() + ")";
        }

        public Builder(String name, CommandParamType type, boolean optional, byte options) {
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.options = options;
        }
    }

    public static enum Option {
        UNKNOWN_0;

    }

    public static enum Type {
        INT,
        FLOAT,
        VALUE,
        WILDCARD_INT,
        OPERATOR,
        TARGET,
        WILDCARD_TARGET,
        FILE_PATH,
        INT_RANGE,
        STRING,
        POSITION,
        MESSAGE,
        TEXT,
        JSON,
        COMMAND;

    }
}

