/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.rcon.codec;

import com.nukkitx.network.rcon.RconMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;

public class RconCodec
extends ByteToMessageCodec<RconMessage> {
    protected void encode(ChannelHandlerContext channelHandlerContext, RconMessage rconMessage, ByteBuf byteBuf) throws Exception {
        byteBuf.writeIntLE(rconMessage.getId());
        byteBuf.writeIntLE(rconMessage.getType());
        ByteBufUtil.writeAscii((ByteBuf)byteBuf, (CharSequence)rconMessage.getBody());
        byteBuf.writeByte(0);
        byteBuf.writeByte(0);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        int id = byteBuf.readIntLE();
        int type = byteBuf.readIntLE();
        String body = this.readNullTerminatedString(byteBuf);
        byteBuf.readerIndex(byteBuf.writerIndex());
        list.add(new RconMessage(id, type, body));
    }

    private String readNullTerminatedString(ByteBuf in) {
        byte readIn;
        StringBuilder read = new StringBuilder();
        while ((readIn = in.readByte()) != 0) {
            read.append((char)readIn);
        }
        return read.toString();
    }
}

