/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.rcon;

import com.nukkitx.network.BootstrapUtils;
import com.nukkitx.network.NetworkListener;
import com.nukkitx.network.handler.ExceptionHandler;
import com.nukkitx.network.rcon.RconEventListener;
import com.nukkitx.network.rcon.codec.RconCodec;
import com.nukkitx.network.rcon.handler.RconHandler;
import com.nukkitx.network.util.NetworkThreadFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class RconNetworkListener
extends ChannelInitializer<SocketChannel>
implements NetworkListener {
    private final RconEventListener eventListener;
    private final InetSocketAddress address;
    private final ServerBootstrap bootstrap;
    private final ExecutorService commandExecutionService = Executors.newSingleThreadExecutor((ThreadFactory)NetworkThreadFactory.builder().daemon(true).format("RCON Command Executor").build());
    private final byte[] password;
    private SocketChannel channel;

    public RconNetworkListener(RconEventListener eventListener, byte[] password, String address, int port) {
        this.eventListener = eventListener;
        this.password = password;
        this.address = new InetSocketAddress(address, port);
        this.bootstrap = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)this);
        BootstrapUtils.setupServerBootstrap((ServerBootstrap)this.bootstrap);
    }

    public boolean bind() {
        return this.bootstrap.bind((SocketAddress)this.address).awaitUninterruptibly().isSuccess();
    }

    public void close() {
        this.commandExecutionService.shutdown();
        try {
            this.commandExecutionService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.bootstrap.config().group().shutdownGracefully();
        if (this.channel != null) {
            this.channel.close().syncUninterruptibly();
        }
    }

    public InetSocketAddress getAddress() {
        return null;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        this.channel = socketChannel;
        this.channel.pipeline().addLast("lengthDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(ByteOrder.LITTLE_ENDIAN, 4096, 0, 4, 0, 4, true));
        this.channel.pipeline().addLast("rconDecoder", (ChannelHandler)new RconCodec());
        this.channel.pipeline().addLast("rconHandler", (ChannelHandler)new RconHandler(this.eventListener, this.password));
        this.channel.pipeline().addLast("lengthPrepender", (ChannelHandler)new LengthFieldPrepender(ByteOrder.LITTLE_ENDIAN, 4, 0, false));
        this.channel.pipeline().addLast("exceptionHandler", (ChannelHandler)new ExceptionHandler());
    }

    public ExecutorService getCommandExecutionService() {
        return this.commandExecutionService;
    }
}

