/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet.util;

import com.nukkitx.network.raknet.RakNetUtils;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;

public class RoundRobinArray<E> {
    private final AtomicReferenceArray<E> elements;
    private final int mask;

    public RoundRobinArray(int fixedCapacity) {
        fixedCapacity = RakNetUtils.powerOfTwoCeiling(fixedCapacity);
        this.elements = new AtomicReferenceArray(fixedCapacity);
        this.mask = fixedCapacity - 1;
    }

    public E get(int index) {
        return this.elements.get(index & this.mask);
    }

    public void set(int index, E value) {
        int idx = index & this.mask;
        E element = this.elements.getAndSet(idx, value);
        ReferenceCountUtil.release(element);
    }

    public boolean remove(int index, E expected) {
        int idx = index & this.mask;
        return this.elements.compareAndSet(idx, expected, null);
    }

    public void forEach(Consumer<E> consumer) {
        int len = this.mask + 1;
        for (int i = 0; i < len; ++i) {
            consumer.accept(this.elements.get(i));
        }
    }
}

