/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.SessionConnection;
import com.nukkitx.network.raknet.EncapsulatedPacket;
import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetDatagram;
import com.nukkitx.network.raknet.RakNetPriority;
import com.nukkitx.network.raknet.RakNetReliability;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.raknet.RakNetSlidingWindow;
import com.nukkitx.network.raknet.RakNetState;
import com.nukkitx.network.raknet.RakNetUtils;
import com.nukkitx.network.raknet.util.BitQueue;
import com.nukkitx.network.raknet.util.FastBinaryMinHeap;
import com.nukkitx.network.raknet.util.IntRange;
import com.nukkitx.network.raknet.util.RoundRobinArray;
import com.nukkitx.network.raknet.util.SplitPacketHelper;
import com.nukkitx.network.util.DisconnectReason;
import com.nukkitx.network.util.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RakNetSession
implements SessionConnection<ByteBuf> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetSession.class);
    private static final AtomicIntegerFieldUpdater<RakNetSession> splitIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "splitIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> datagramReadIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "datagramReadIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> datagramWriteIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "datagramWriteIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> reliabilityWriteIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "reliabilityWriteIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> unackedBytesUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "unackedBytes");
    final InetSocketAddress address;
    private final Channel channel;
    private final ChannelPromise voidPromise;
    final EventLoop eventLoop;
    private int mtu;
    private int adjustedMtu;
    long guid;
    private volatile RakNetState state = RakNetState.UNCONNECTED;
    private volatile long lastTouched = System.currentTimeMillis();
    volatile boolean closed = false;
    private RakNetSlidingWindow slidingWindow;
    private volatile int splitIndex;
    private volatile int datagramReadIndex;
    private volatile int datagramWriteIndex;
    private Lock reliabilityReadLock;
    private int reliabilityReadIndex;
    private volatile int reliabilityWriteIndex;
    private int[] orderReadIndex;
    private AtomicIntegerArray orderWriteIndex;
    private AtomicIntegerArray sequenceReadIndex;
    private AtomicIntegerArray sequenceWriteIndex;
    private Lock outgoingLock;
    private RoundRobinArray<SplitPacketHelper> splitPackets;
    private BitQueue reliableDatagramQueue;
    private FastBinaryMinHeap<EncapsulatedPacket> outgoingPackets;
    private long[] outgoingPacketNextWeights;
    private FastBinaryMinHeap<EncapsulatedPacket>[] orderingHeaps;
    private Lock orderingLock;
    private volatile RakNetSessionListener listener = null;
    private volatile long currentPingTime = -1L;
    private volatile long lastPingTime = -1L;
    private volatile long lastPongTime = -1L;
    private ConcurrentMap<Integer, RakNetDatagram> sentDatagrams;
    private Queue<IntRange> incomingAcks;
    private Queue<IntRange> incomingNaks;
    private Queue<IntRange> outgoingAcks;
    private Queue<IntRange> outgoingNaks;
    private volatile int unackedBytes;
    private volatile long lastMinWeight;

    RakNetSession(InetSocketAddress address, Channel channel, int mtu, EventLoop eventLoop) {
        this.address = address;
        this.channel = channel;
        this.setMtu(mtu);
        this.eventLoop = eventLoop;
        this.voidPromise = channel.voidPromise();
    }

    final void initialize() {
        Preconditions.checkState((this.state == RakNetState.INITIALIZING ? 1 : 0) != 0);
        this.slidingWindow = new RakNetSlidingWindow(this.mtu);
        this.reliableDatagramQueue = new BitQueue(512);
        this.reliabilityReadLock = new ReentrantLock(true);
        this.orderReadIndex = new int[16];
        this.orderWriteIndex = new AtomicIntegerArray(16);
        this.sequenceReadIndex = new AtomicIntegerArray(16);
        this.sequenceWriteIndex = new AtomicIntegerArray(16);
        this.orderingHeaps = new FastBinaryMinHeap[16];
        this.orderingLock = new ReentrantLock(true);
        this.splitPackets = new RoundRobinArray(256);
        this.sentDatagrams = new ConcurrentSkipListMap<Integer, RakNetDatagram>();
        for (int i = 0; i < 16; ++i) {
            this.orderingHeaps[i] = new FastBinaryMinHeap(64);
        }
        this.outgoingLock = new ReentrantLock(true);
        this.outgoingPackets = new FastBinaryMinHeap(8);
        this.incomingAcks = PlatformDependent.newMpscQueue();
        this.incomingNaks = PlatformDependent.newMpscQueue();
        this.outgoingAcks = PlatformDependent.newMpscQueue();
        this.outgoingNaks = PlatformDependent.newMpscQueue();
        this.outgoingPacketNextWeights = new long[4];
        this.initHeapWeights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deinitialize() {
        this.slidingWindow = null;
        this.reliableDatagramQueue = null;
        this.orderReadIndex = null;
        this.orderWriteIndex = null;
        this.sequenceReadIndex = null;
        this.sequenceWriteIndex = null;
        RoundRobinArray<SplitPacketHelper> splitPackets = this.splitPackets;
        this.splitPackets = null;
        if (splitPackets != null) {
            splitPackets.forEach(ReferenceCountUtil::release);
        }
        ConcurrentMap<Integer, RakNetDatagram> sentDatagrams = this.sentDatagrams;
        this.sentDatagrams = null;
        if (sentDatagrams != null) {
            sentDatagrams.values().forEach(ReferenceCountUtil::release);
        }
        if (this.orderingLock != null) {
            this.orderingLock.lock();
            try {
                FastBinaryMinHeap<EncapsulatedPacket>[] orderingHeaps = this.orderingHeaps;
                this.orderingHeaps = null;
                if (orderingHeaps != null) {
                    for (FastBinaryMinHeap<EncapsulatedPacket> orderingHeap : orderingHeaps) {
                        EncapsulatedPacket packet;
                        while ((packet = orderingHeap.poll()) != null) {
                            packet.release();
                        }
                    }
                }
            }
            finally {
                this.orderingLock.unlock();
            }
        }
        if (this.outgoingLock != null) {
            this.outgoingLock.lock();
            try {
                FastBinaryMinHeap<EncapsulatedPacket> outgoingPackets = this.outgoingPackets;
                this.outgoingPackets = null;
                if (outgoingPackets != null) {
                    EncapsulatedPacket packet;
                    while ((packet = outgoingPackets.poll()) != null) {
                        packet.release();
                    }
                }
                this.initHeapWeights();
            }
            finally {
                this.outgoingLock.unlock();
            }
        }
        this.incomingAcks = null;
        this.incomingNaks = null;
        this.outgoingAcks = null;
        this.outgoingNaks = null;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getMtu() {
        return this.mtu;
    }

    void setMtu(int mtu) {
        this.mtu = RakNetUtils.clamp(mtu, 400, 6000);
        this.adjustedMtu = this.mtu - 8 - (this.address.getAddress() instanceof Inet6Address ? 40 : 20);
    }

    public long getPing() {
        return this.lastPongTime - this.lastPingTime;
    }

    public double getRTT() {
        return this.slidingWindow.getRTT();
    }

    public ByteBuf allocateBuffer(int capacity) {
        return this.channel.alloc().ioBuffer(capacity);
    }

    private void initHeapWeights() {
        for (int priorityLevel = 0; priorityLevel < 4; ++priorityLevel) {
            this.outgoingPacketNextWeights[priorityLevel] = (1 << priorityLevel) * priorityLevel + priorityLevel;
        }
    }

    private long getNextWeight(RakNetPriority priority) {
        int priorityLevel = priority.ordinal();
        long next = this.outgoingPacketNextWeights[priorityLevel];
        if (!this.outgoingPackets.isEmpty()) {
            if (next >= this.lastMinWeight) {
                next = this.lastMinWeight + (long)((1 << priorityLevel) * priorityLevel) + (long)priorityLevel;
                this.outgoingPacketNextWeights[priorityLevel] = next + (long)((1 << priorityLevel) * (priorityLevel + 1)) + (long)priorityLevel;
            }
        } else {
            this.initHeapWeights();
        }
        this.lastMinWeight = next - (long)((1 << priorityLevel) * priorityLevel) + (long)priorityLevel;
        return next;
    }

    private EncapsulatedPacket getReassembledPacket(EncapsulatedPacket splitPacket) {
        EncapsulatedPacket result;
        this.checkForClosed();
        SplitPacketHelper helper = this.splitPackets.get(splitPacket.getPartId());
        if (helper == null) {
            helper = new SplitPacketHelper(splitPacket.getPartCount());
            this.splitPackets.set(splitPacket.getPartId(), helper);
        }
        if ((result = helper.add(splitPacket, this)) != null && this.splitPackets.remove(splitPacket.getPartId(), helper)) {
            helper.release();
        }
        return result;
    }

    void onDatagram(DatagramPacket datagram) {
        boolean rakNetDatagram;
        if (!((InetSocketAddress)datagram.sender()).equals(this.address) || this.closed) {
            return;
        }
        this.touch();
        ByteBuf buffer = (ByteBuf)datagram.content();
        byte potentialFlags = buffer.readByte();
        boolean bl = rakNetDatagram = (potentialFlags & 0xFFFFFF80) != 0;
        if (rakNetDatagram) {
            if (this.state.ordinal() >= RakNetState.INITIALIZED.ordinal()) {
                if ((potentialFlags & 0x40) != 0) {
                    this.onAcknowledge(buffer, this.incomingAcks);
                } else if ((potentialFlags & 0x20) != 0) {
                    this.onAcknowledge(buffer, this.incomingNaks);
                } else {
                    buffer.readerIndex(0);
                    this.onRakNetDatagram(buffer);
                }
            }
        } else {
            buffer.readerIndex(0);
            this.onPacketInternal(buffer);
        }
    }

    private void onEncapsulatedInternal(EncapsulatedPacket packet) {
        ByteBuf buffer = packet.buffer;
        short packetId = buffer.readUnsignedByte();
        switch (packetId) {
            case 0: {
                this.onConnectedPing(buffer);
                break;
            }
            case 3: {
                this.onConnectedPong(buffer);
                break;
            }
            case 21: {
                this.onDisconnectionNotification();
                break;
            }
            default: {
                buffer.readerIndex(0);
                if (packetId >= 128) {
                    if (this.listener == null) break;
                    this.listener.onEncapsulated(packet);
                    break;
                }
                this.onPacket(buffer);
            }
        }
    }

    private void onPacketInternal(ByteBuf buffer) {
        short packetId = buffer.getUnsignedByte(buffer.readerIndex());
        buffer.readerIndex(0);
        if (packetId >= 128) {
            if (this.listener != null) {
                this.listener.onDirect(buffer);
            }
        } else {
            this.onPacket(buffer);
        }
    }

    protected abstract void onPacket(ByteBuf var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRakNetDatagram(ByteBuf buffer) {
        if (this.state == null || RakNetState.INITIALIZED.compareTo(this.state) > 0) {
            return;
        }
        RakNetDatagram datagram = new RakNetDatagram(System.currentTimeMillis());
        datagram.decode(buffer);
        this.slidingWindow.onPacketReceived(datagram.sendTime);
        int prevSequenceIndex = datagramReadIndexUpdater.getAndAccumulate(this, datagram.sequenceIndex, (prev, newIndex) -> prev <= newIndex ? newIndex + 1 : prev);
        int missedDatagrams = datagram.sequenceIndex - prevSequenceIndex;
        if (missedDatagrams > 0) {
            this.outgoingNaks.offer(new IntRange(datagram.sequenceIndex - missedDatagrams, datagram.sequenceIndex));
        }
        this.outgoingAcks.offer(new IntRange(datagram.sequenceIndex, datagram.sequenceIndex));
        for (EncapsulatedPacket encapsulated : datagram.packets) {
            if (encapsulated.reliability.isReliable()) {
                this.reliabilityReadLock.lock();
                try {
                    int missed = encapsulated.reliabilityIndex - this.reliabilityReadIndex;
                    if (missed > 0) {
                        if (missed < this.reliableDatagramQueue.size()) {
                            if (!this.reliableDatagramQueue.get(missed)) continue;
                            this.reliableDatagramQueue.set(missed, false);
                        } else {
                            int count = missed - this.reliableDatagramQueue.size();
                            for (int i = 0; i < count; ++i) {
                                this.reliableDatagramQueue.add(true);
                            }
                            this.reliableDatagramQueue.add(false);
                        }
                    } else {
                        if (missed != 0) continue;
                        ++this.reliabilityReadIndex;
                        if (!this.reliableDatagramQueue.isEmpty()) {
                            this.reliableDatagramQueue.poll();
                        }
                    }
                    while (!this.reliableDatagramQueue.isEmpty() && !this.reliableDatagramQueue.peek()) {
                        this.reliableDatagramQueue.poll();
                        ++this.reliabilityReadIndex;
                    }
                }
                finally {
                    this.reliabilityReadLock.unlock();
                    continue;
                }
            }
            if (encapsulated.split) {
                EncapsulatedPacket reassembled = this.getReassembledPacket(encapsulated);
                if (reassembled == null) continue;
                try {
                    this.checkForOrdered(reassembled);
                    continue;
                }
                finally {
                    reassembled.release();
                    continue;
                }
            }
            this.checkForOrdered(encapsulated);
        }
    }

    private void checkForOrdered(EncapsulatedPacket packet) {
        if (packet.getReliability().isOrdered()) {
            this.onOrderedReceived(packet);
        } else {
            this.onEncapsulatedInternal(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOrderedReceived(EncapsulatedPacket packet) {
        this.orderingLock.lock();
        try {
            EncapsulatedPacket queuedPacket;
            FastBinaryMinHeap<EncapsulatedPacket> binaryHeap = this.orderingHeaps[packet.orderingChannel];
            if (this.orderReadIndex[packet.orderingChannel] < packet.orderingIndex) {
                binaryHeap.insert(packet.orderingIndex, packet.retain());
                return;
            }
            if (this.orderReadIndex[packet.orderingChannel] > packet.orderingIndex) {
                return;
            }
            short s = packet.orderingChannel;
            this.orderReadIndex[s] = this.orderReadIndex[s] + 1;
            this.onEncapsulatedInternal(packet);
            while ((queuedPacket = binaryHeap.peek()) != null && queuedPacket.orderingIndex == this.orderReadIndex[packet.orderingChannel]) {
                try {
                    binaryHeap.remove();
                    short s2 = packet.orderingChannel;
                    this.orderReadIndex[s2] = this.orderReadIndex[s2] + 1;
                    this.onEncapsulatedInternal(queuedPacket);
                }
                finally {
                    queuedPacket.release();
                }
            }
        }
        finally {
            this.orderingLock.unlock();
        }
    }

    final void onTick(long curTime) {
        if (this.closed) {
            return;
        }
        this.tick(curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick(long curTime) {
        RakNetDatagram datagram;
        int i;
        IntRange range;
        if (this.isTimedOut()) {
            this.close(DisconnectReason.TIMED_OUT);
            return;
        }
        if (this.state == null || this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
            return;
        }
        if (this.currentPingTime + 2000L < curTime) {
            this.sendConnectedPing(curTime);
        }
        if (!this.incomingAcks.isEmpty()) {
            while ((range = this.incomingAcks.poll()) != null) {
                for (i = range.start; i <= range.end; ++i) {
                    datagram = (RakNetDatagram)((Object)this.sentDatagrams.remove(i));
                    if (datagram == null) continue;
                    datagram.release();
                    unackedBytesUpdater.addAndGet(this, -datagram.getSize());
                    this.slidingWindow.onAck(curTime - datagram.sendTime, datagram.sequenceIndex, this.datagramReadIndex);
                }
            }
        }
        if (!this.incomingNaks.isEmpty()) {
            this.slidingWindow.onNak();
            while ((range = this.incomingNaks.poll()) != null) {
                for (i = range.start; i <= range.end; ++i) {
                    datagram = (RakNetDatagram)((Object)this.sentDatagrams.get(i));
                    if (datagram == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("NAK'ed datagram {} from {}", (Object)datagram.sequenceIndex, (Object)this.address);
                    }
                    this.sendDatagram(datagram.retain(), curTime, false);
                }
            }
        }
        int mtu = this.adjustedMtu - 4;
        while (!this.outgoingNaks.isEmpty()) {
            ByteBuf buffer = this.allocateBuffer(mtu);
            buffer.writeByte(-96);
            RakNetUtils.writeIntRanges(buffer, this.outgoingNaks, mtu - 1);
            this.sendDirect(buffer);
        }
        if (this.slidingWindow.shouldSendAcks(curTime)) {
            while (!this.outgoingAcks.isEmpty()) {
                ByteBuf buffer = this.allocateBuffer(mtu);
                buffer.writeByte(-64);
                RakNetUtils.writeIntRanges(buffer, this.outgoingAcks, mtu - 1);
                this.sendDirect(buffer);
                this.slidingWindow.onSendAck();
            }
        }
        if (!this.sentDatagrams.isEmpty()) {
            int transmissionBandwidth = this.slidingWindow.getRetransmissionBandwidth(this.unackedBytes);
            boolean hasResent = false;
            for (RakNetDatagram datagram2 : this.sentDatagrams.values()) {
                if (datagram2.nextSend > curTime) continue;
                int size = datagram2.getSize();
                if (transmissionBandwidth < size) break;
                transmissionBandwidth -= size;
                if (!hasResent) {
                    hasResent = true;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Stale datagram {} from {}", (Object)datagram2.sequenceIndex, (Object)this.address);
                }
                this.sendDatagram(datagram2.retain(), curTime, false);
            }
            if (hasResent) {
                this.slidingWindow.onResend(curTime);
            }
        }
        this.outgoingLock.lock();
        try {
            if (!this.outgoingPackets.isEmpty()) {
                EncapsulatedPacket packet;
                int size;
                RakNetDatagram datagram3 = new RakNetDatagram(curTime);
                for (int transmissionBandwidth = this.slidingWindow.getTransmissionBandwidth(this.unackedBytes); (packet = this.outgoingPackets.peek()) != null && transmissionBandwidth >= (size = packet.getSize()); transmissionBandwidth -= size) {
                    this.outgoingPackets.remove();
                    if (datagram3.tryAddPacket(packet, this.adjustedMtu)) continue;
                    this.sendDatagram(datagram3, curTime, true);
                    datagram3 = new RakNetDatagram(curTime);
                    Preconditions.checkArgument((boolean)datagram3.tryAddPacket(packet, this.adjustedMtu), (String)"Packet too large to fit in MTU (size: %s, MTU: %s)", (int)packet.getSize(), (int)this.adjustedMtu);
                }
                if (!datagram3.packets.isEmpty()) {
                    this.sendDatagram(datagram3, curTime, true);
                }
            }
        }
        finally {
            this.outgoingLock.unlock();
        }
        this.channel.flush();
    }

    public void disconnect() {
        this.disconnect(DisconnectReason.DISCONNECTED);
    }

    public void disconnect(DisconnectReason reason) {
        if (this.closed) {
            return;
        }
        this.sendDisconnectionNotification();
        this.close(reason);
    }

    public void close() {
        this.close(DisconnectReason.DISCONNECTED);
    }

    public void close(DisconnectReason reason) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.state = RakNetState.UNCONNECTED;
        this.onClose();
        if (log.isTraceEnabled()) {
            log.trace("RakNet Session ({} => {}) closed: {}", new Object[]{this.getRakNet().bindAddress, this.address, reason});
        }
        this.deinitialize();
        if (this.listener != null) {
            this.listener.onDisconnect(reason);
        }
    }

    protected void onClose() {
    }

    public void sendImmediate(ByteBuf buf) {
        this.send(buf, RakNetPriority.IMMEDIATE);
    }

    public void send(ByteBuf buf) {
        this.send(buf, RakNetPriority.MEDIUM);
    }

    public void send(ByteBuf buf, RakNetPriority priority) {
        this.send(buf, priority, RakNetReliability.RELIABLE_ORDERED);
    }

    public void send(ByteBuf buf, RakNetReliability reliability) {
        this.send(buf, RakNetPriority.MEDIUM, reliability);
    }

    public void send(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability) {
        this.send(buf, priority, reliability, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability, @Nonnegative int orderingChannel) {
        try {
            if (this.closed || this.state == null || this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
                return;
            }
            EncapsulatedPacket[] packets = this.createEncapsulated(buf, priority, reliability, orderingChannel);
            if (priority == RakNetPriority.IMMEDIATE) {
                this.sendImmediate(packets);
                return;
            }
            this.outgoingLock.lock();
            try {
                long weight = this.getNextWeight(priority);
                if (packets.length == 1) {
                    this.outgoingPackets.insert(weight, packets[0]);
                } else {
                    this.outgoingPackets.insertSeries(weight, (EncapsulatedPacket[])packets);
                }
            }
            finally {
                this.outgoingLock.unlock();
            }
        }
        finally {
            buf.release();
        }
    }

    private void sendImmediate(EncapsulatedPacket[] packets) {
        long curTime = System.currentTimeMillis();
        EncapsulatedPacket[] encapsulatedPacketArray = packets;
        int n = encapsulatedPacketArray.length;
        for (int i = 0; i < n; ++i) {
            RakNetDatagram datagram = new RakNetDatagram(curTime);
            EncapsulatedPacket packet = encapsulatedPacketArray[i];
            if (!datagram.tryAddPacket(packet, this.adjustedMtu)) {
                throw new IllegalArgumentException("Packet too large to fit in MTU (size: " + packet.getSize() + ", MTU: " + this.adjustedMtu + ")");
            }
            this.sendDatagram(datagram, curTime, true);
        }
        this.channel.flush();
    }

    private EncapsulatedPacket[] createEncapsulated(ByteBuf buffer, RakNetPriority priority, RakNetReliability reliability, int orderingChannel) {
        ByteBuf[] buffers;
        int maxLength = this.adjustedMtu - 28 - 4;
        int splitId = 0;
        if (buffer.readableBytes() > maxLength) {
            switch (reliability) {
                case UNRELIABLE: {
                    reliability = RakNetReliability.RELIABLE;
                    break;
                }
                case UNRELIABLE_SEQUENCED: {
                    reliability = RakNetReliability.RELIABLE_SEQUENCED;
                    break;
                }
                case UNRELIABLE_WITH_ACK_RECEIPT: {
                    reliability = RakNetReliability.RELIABLE_WITH_ACK_RECEIPT;
                }
            }
            int split = (buffer.readableBytes() - 1) / maxLength + 1;
            buffer.retain(split);
            buffers = new ByteBuf[split];
            for (int i = 0; i < split; ++i) {
                buffers[i] = buffer.readSlice(Math.min(maxLength, buffer.readableBytes()));
            }
            if (buffer.isReadable()) {
                throw new IllegalStateException("Buffer still has bytes to read!");
            }
            splitId = splitIndexUpdater.getAndIncrement(this);
        } else {
            buffers = new ByteBuf[]{buffer.readRetainedSlice(buffer.readableBytes())};
        }
        int orderingIndex = 0;
        if (reliability.isOrdered()) {
            orderingIndex = this.orderWriteIndex.getAndIncrement(orderingChannel);
        }
        EncapsulatedPacket[] packets = new EncapsulatedPacket[buffers.length];
        int parts = buffers.length;
        for (int i = 0; i < parts; ++i) {
            EncapsulatedPacket packet = new EncapsulatedPacket();
            packet.buffer = buffers[i];
            packet.orderingChannel = (short)orderingChannel;
            packet.orderingIndex = orderingIndex;
            packet.reliability = reliability;
            packet.priority = priority;
            if (reliability.isReliable()) {
                packet.reliabilityIndex = reliabilityWriteIndexUpdater.getAndIncrement(this);
            }
            if (parts > 1) {
                packet.split = true;
                packet.partIndex = i;
                packet.partCount = parts;
                packet.partId = splitId;
            }
            packets[i] = packet;
        }
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDatagram(RakNetDatagram datagram, long time, boolean firstSend) {
        Preconditions.checkArgument((!datagram.packets.isEmpty() ? 1 : 0) != 0, (Object)"RakNetDatagram with no packets");
        try {
            ByteBuf buf;
            if (datagram.sequenceIndex == -1) {
                datagram.sequenceIndex = datagramWriteIndexUpdater.getAndIncrement(this);
            }
            for (EncapsulatedPacket packet : datagram.packets) {
                if (packet.reliability == RakNetReliability.UNRELIABLE || packet.reliability == RakNetReliability.UNRELIABLE_SEQUENCED) continue;
                datagram.nextSend = time + this.slidingWindow.getRtoForRetransmission();
                if (!firstSend) break;
                this.sentDatagrams.put(datagram.sequenceIndex, datagram.retain());
                unackedBytesUpdater.addAndGet(this, datagram.getSize());
                break;
            }
            Preconditions.checkArgument(((buf = this.allocateBuffer(datagram.getSize())).writerIndex() < this.adjustedMtu ? 1 : 0) != 0, (String)"Packet length was %s but expected %s", (int)buf.writerIndex(), (int)this.adjustedMtu);
            datagram.encode(buf);
            this.channel.write((Object)new DatagramPacket(buf, this.address), this.voidPromise);
        }
        finally {
            datagram.release();
        }
    }

    void sendDirect(ByteBuf buffer) {
        this.channel.writeAndFlush((Object)new DatagramPacket(buffer, this.address), this.voidPromise);
    }

    private void onAcknowledge(ByteBuf buffer, Queue<IntRange> queue) {
        this.checkForClosed();
        int size = buffer.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int end;
            boolean singleton = buffer.readBoolean();
            int start = buffer.readUnsignedMediumLE();
            int n = end = singleton ? start : buffer.readMediumLE();
            if (start > end) {
                if (log.isTraceEnabled()) {
                    log.trace("{} sent an IntRange with a start value {} greater than an end value of {}", new Object[]{this.address, start, end});
                }
                this.disconnect(DisconnectReason.BAD_PACKET);
                return;
            }
            queue.offer(new IntRange(start, end));
        }
    }

    private void onConnectedPing(ByteBuf buffer) {
        long pingTime = buffer.readLong();
        this.sendConnectedPong(pingTime);
    }

    private void onConnectedPong(ByteBuf buffer) {
        long pingTime = buffer.readLong();
        if (this.currentPingTime == pingTime) {
            this.lastPingTime = this.currentPingTime;
            this.lastPongTime = System.currentTimeMillis();
        }
    }

    private void onDisconnectionNotification() {
        this.close(DisconnectReason.CLOSED_BY_REMOTE_PEER);
    }

    private void sendConnectedPing(long pingTime) {
        ByteBuf buffer = this.allocateBuffer(9);
        buffer.writeByte(0);
        buffer.writeLong(pingTime);
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.RELIABLE);
        this.currentPingTime = pingTime;
    }

    private void sendConnectedPong(long pingTime) {
        ByteBuf buffer = this.allocateBuffer(17);
        buffer.writeByte(3);
        buffer.writeLong(pingTime);
        buffer.writeLong(System.currentTimeMillis());
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.RELIABLE);
    }

    private void sendDisconnectionNotification() {
        ByteBuf buffer = this.allocateBuffer(1);
        buffer.writeByte(21);
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.RELIABLE_ORDERED);
    }

    private void sendDetectLostConnection() {
        ByteBuf buffer = this.allocateBuffer(1);
        buffer.writeByte(4);
        this.send(buffer, RakNetPriority.IMMEDIATE);
    }

    private void touch() {
        this.checkForClosed();
        this.lastTouched = System.currentTimeMillis();
    }

    public boolean isStale() {
        return System.currentTimeMillis() - this.lastTouched >= 5000L;
    }

    public boolean isTimedOut() {
        return System.currentTimeMillis() - this.lastTouched >= 30000L;
    }

    private void checkForClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Session already closed");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public abstract RakNet getRakNet();

    boolean isIpv6Session() {
        return this.address.getAddress() instanceof Inet6Address;
    }

    public RakNetState getState() {
        return this.state;
    }

    void setState(@Nullable RakNetState state) {
        if (this.state != state) {
            this.state = state;
            if (this.listener != null) {
                this.listener.onSessionChangeState(this.state);
            }
        }
    }

    public RakNetSessionListener getListener() {
        return this.listener;
    }

    public void setListener(RakNetSessionListener listener) {
        this.listener = listener;
    }
}

