/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.raknet.EncapsulatedPacket;
import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class RakNetDatagram
extends AbstractReferenceCounted {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetDatagram.class);
    final List<EncapsulatedPacket> packets = new ArrayList<EncapsulatedPacket>();
    byte flags = (byte)-128;
    final long sendTime;
    long nextSend;
    int sequenceIndex = -1;

    public RakNetDatagram retain() {
        super.retain();
        return this;
    }

    public RakNetDatagram retain(int increment) {
        super.retain(increment);
        return this;
    }

    public RakNetDatagram touch(Object hint) {
        for (EncapsulatedPacket packet : this.packets) {
            packet.touch(hint);
        }
        return this;
    }

    void decode(ByteBuf buf) {
        this.flags = buf.readByte();
        this.sequenceIndex = buf.readUnsignedMediumLE();
        while (buf.isReadable()) {
            EncapsulatedPacket packet = new EncapsulatedPacket();
            packet.decode(buf);
            this.packets.add(packet);
        }
    }

    public void encode(ByteBuf buf) {
        buf.writeByte((int)this.flags);
        buf.writeMediumLE(this.sequenceIndex);
        for (EncapsulatedPacket packet : this.packets) {
            packet.encode(buf);
        }
    }

    boolean tryAddPacket(EncapsulatedPacket packet, int mtu) {
        if (this.getSize() + packet.getSize() > mtu - 4) {
            return false;
        }
        this.packets.add(packet);
        if (packet.split) {
            this.flags = (byte)(this.flags | 8);
        }
        return true;
    }

    public boolean release() {
        return super.release();
    }

    protected void deallocate() {
        for (EncapsulatedPacket packet : this.packets) {
            packet.release();
        }
    }

    public int getSize() {
        int size = 4;
        for (EncapsulatedPacket packet : this.packets) {
            size += packet.getSize();
        }
        return size;
    }

    public RakNetDatagram(long sendTime) {
        this.sendTime = sendTime;
    }

    public List<EncapsulatedPacket> getPackets() {
        return this.packets;
    }

    public byte getFlags() {
        return this.flags;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public long getNextSend() {
        return this.nextSend;
    }

    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public void setNextSend(long nextSend) {
        this.nextSend = nextSend;
    }

    public void setSequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RakNetDatagram)) {
            return false;
        }
        RakNetDatagram other = (RakNetDatagram)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<EncapsulatedPacket> this$packets = this.getPackets();
        List<EncapsulatedPacket> other$packets = other.getPackets();
        if (this$packets == null ? other$packets != null : !((Object)this$packets).equals(other$packets)) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getSendTime() != other.getSendTime()) {
            return false;
        }
        if (this.getNextSend() != other.getNextSend()) {
            return false;
        }
        return this.getSequenceIndex() == other.getSequenceIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RakNetDatagram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EncapsulatedPacket> $packets = this.getPackets();
        result = result * 59 + ($packets == null ? 43 : ((Object)$packets).hashCode());
        result = result * 59 + this.getFlags();
        long $sendTime = this.getSendTime();
        result = result * 59 + (int)($sendTime >>> 32 ^ $sendTime);
        long $nextSend = this.getNextSend();
        result = result * 59 + (int)($nextSend >>> 32 ^ $nextSend);
        result = result * 59 + this.getSequenceIndex();
        return result;
    }

    public String toString() {
        return "RakNetDatagram(packets=" + this.getPackets() + ", flags=" + this.getFlags() + ", sendTime=" + this.getSendTime() + ", nextSend=" + this.getNextSend() + ", sequenceIndex=" + this.getSequenceIndex() + ")";
    }
}

