/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.util.Bootstraps;
import com.nukkitx.network.util.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RakNet
implements AutoCloseable {
    final long guid = ThreadLocalRandom.current().nextLong();
    final Bootstrap bootstrap;
    final EventLoopGroup eventLoopGroup;
    final InetSocketAddress bindAddress;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledFuture<?> tickFuture;
    int protocolVersion = 9;
    private volatile boolean closed;

    RakNet(InetSocketAddress bindAddress, EventLoopGroup eventLoopGroup) {
        this.bindAddress = bindAddress;
        this.eventLoopGroup = eventLoopGroup;
        this.bootstrap = (Bootstrap)new Bootstrap().option(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT);
        Bootstraps.setupBootstrap((Bootstrap)this.bootstrap, (boolean)true);
        this.bootstrap.group(eventLoopGroup);
    }

    static void send(ChannelHandlerContext ctx, InetSocketAddress recipient, ByteBuf buffer) {
        ctx.writeAndFlush((Object)new DatagramPacket(buffer, recipient), ctx.voidPromise());
    }

    public CompletableFuture<Void> bind() {
        Preconditions.checkState((boolean)this.running.compareAndSet(false, true), (Object)"RakNet has already been started");
        CompletableFuture<Void> future = this.bindInternal();
        future.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.running.compareAndSet(true, false);
            } else {
                this.closed = false;
                this.tickFuture = this.eventLoopGroup.scheduleAtFixedRate(this::onTick, 0L, 10L, TimeUnit.MILLISECONDS);
            }
        });
        return future;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.tickFuture != null) {
            this.tickFuture.cancel(false);
        }
    }

    protected abstract CompletableFuture<Void> bindInternal();

    protected abstract void onTick();

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Nonnegative
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(@Nonnegative int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public long getGuid() {
        return this.guid;
    }
}

