/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet.util;

import com.nukkitx.network.raknet.RakNetUtils;
import io.netty.util.ReferenceCountUtil;
import java.util.function.Consumer;

public class RoundRobinArray<E> {
    private final Object[] elements;
    private final int mask;

    public RoundRobinArray(int fixedCapacity) {
        fixedCapacity = RakNetUtils.powerOfTwoCeiling(fixedCapacity);
        this.elements = new Object[fixedCapacity];
        this.mask = fixedCapacity - 1;
    }

    public E get(int index) {
        return (E)this.elements[index & this.mask];
    }

    public void set(int index, E value) {
        int idx = index & this.mask;
        Object element = this.elements[idx];
        this.elements[idx] = value;
        ReferenceCountUtil.release((Object)element);
    }

    public E remove(int index) {
        int idx = index & this.mask;
        Object removed = this.elements[idx];
        this.elements[idx] = null;
        return (E)removed;
    }

    public int size() {
        return this.elements.length;
    }

    public void forEach(Consumer<E> consumer) {
        for (Object element : this.elements) {
            consumer.accept(element);
        }
    }
}

