/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet.util;

import com.nukkitx.network.raknet.RakNetUtils;

public class BitQueue {
    private int capacity;
    private long[] queue;
    private int head;
    private int tail;

    public BitQueue(int capacity) {
        this.capacity = RakNetUtils.powerOfTwoCeiling(capacity);
        this.queue = this.newArray(this.capacity + 1);
        this.head = 0;
        this.tail = 0;
    }

    public void resize(int newCapacity) {
        int size = this.size();
        if (newCapacity < size) {
            throw new IndexOutOfBoundsException("Resizing would lose data");
        }
        if (++newCapacity == this.capacity) {
            return;
        }
        long[] newQueue = this.newArray(newCapacity);
        if ((this.tail & 0x3F) == 0) {
            if (this.head > this.tail) {
                int srcPos = this.tail >> 6;
                int length = this.head - this.tail + 63 >> 6;
                System.arraycopy(this.queue, srcPos, newQueue, 0, length);
            } else if (this.head < this.tail) {
                int srcPos = this.tail >> 6;
                int adjustedPos = (this.capacity << 6) - this.tail + 63 >> 6;
                int length = this.head + 63 >> 6;
                System.arraycopy(this.queue, srcPos, newQueue, 0, adjustedPos);
                System.arraycopy(this.queue, srcPos, newQueue, adjustedPos, length);
            }
        } else {
            int tailBits = this.tail & 0x3F;
            int tailIdx = this.tail >> 6;
            int by2 = tailIdx + 1 & this.capacity - 1;
            for (int cursor = 0; cursor < size; cursor += 8) {
                long mask = (1L << tailBits) - 1L & 0xFFL;
                long bit1 = (this.queue[tailIdx] & ((mask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFL)) >>> tailBits;
                long bit2 = this.queue[by2] << 64 - tailBits;
                newQueue[cursor >> 6] = bit1 | bit2;
                tailIdx = tailIdx + 1 & this.capacity - 1;
                by2 = by2 + 1 & this.capacity - 1;
            }
            this.tail = 0;
            this.head = size;
        }
        this.capacity = newCapacity;
        this.queue = newQueue;
        this.head = 0;
        this.tail = size;
    }

    private long[] newArray(int capacity) {
        return new long[capacity + 63 >> 6];
    }

    public void add(boolean val) {
        if ((this.head + 1 & (this.queue.length << 6) - 1) == this.tail) {
            this.resize(this.queue.length << 7);
        }
        int idx = this.head >> 6;
        long mask = 1L << (this.tail & 0x3F);
        int n = idx;
        this.queue[n] = this.queue[n] ^ ((long)(val ? 255 : 0) ^ this.queue[idx]) & mask;
        this.head = this.head + 1 & (this.queue.length << 6) - 1;
    }

    public void set(int i, boolean val) {
        if (i >= this.size() || i < 0) {
            return;
        }
        int idx = this.tail + i & (this.queue.length << 6) - 1;
        int arrIdx = idx >> 6;
        long mask = 1L << (idx & 0x3F);
        int n = arrIdx;
        this.queue[n] = this.queue[n] ^ ((long)(val ? 255 : 0) ^ this.queue[arrIdx]) & mask;
    }

    public boolean poll() {
        if (this.head == this.tail) {
            return false;
        }
        int arrIdx = this.tail >> 6;
        long mask = 1L << (this.tail & 0x3F);
        this.tail = this.tail + 1 & (this.queue.length << 6) - 1;
        return (this.queue[arrIdx] & mask) != 0L;
    }

    public boolean peek() {
        if (this.head == this.tail) {
            return false;
        }
        int arrIdx = this.tail >> 6;
        long mask = 1L << (this.tail & 0x3F);
        return (this.queue[arrIdx] & mask) != 0L;
    }

    public boolean get(int i) {
        int size = this.size();
        if (i < 0 || i >= size) {
            String msg = "Index " + i + ", queue size " + size;
            throw new IndexOutOfBoundsException(msg);
        }
        int index = this.tail + i & (this.queue.length << 6) - 1;
        int arrIndex = index >> 6;
        long mask = 1L << (index & 0x3F);
        return (this.queue[arrIndex] & mask) != 0L;
    }

    public int size() {
        if (this.head > this.tail) {
            return this.head - this.tail;
        }
        if (this.head < this.tail) {
            return (this.queue.length << 6) - (this.tail - this.head);
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }
}

