/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.SessionConnection;
import com.nukkitx.network.raknet.EncapsulatedPacket;
import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetDatagram;
import com.nukkitx.network.raknet.RakNetPriority;
import com.nukkitx.network.raknet.RakNetReliability;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.raknet.RakNetSlidingWindow;
import com.nukkitx.network.raknet.RakNetState;
import com.nukkitx.network.raknet.RakNetUtils;
import com.nukkitx.network.raknet.util.BitQueue;
import com.nukkitx.network.raknet.util.FastBinaryMinHeap;
import com.nukkitx.network.raknet.util.IntRange;
import com.nukkitx.network.raknet.util.RoundRobinArray;
import com.nukkitx.network.raknet.util.SplitPacketHelper;
import com.nukkitx.network.util.DisconnectReason;
import com.nukkitx.network.util.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RakNetSession
implements SessionConnection<ByteBuf> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetSession.class);
    private static final AtomicIntegerFieldUpdater<RakNetSession> splitIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "splitIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> datagramReadIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "datagramReadIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> datagramWriteIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "datagramWriteIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> reliabilityWriteIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "reliabilityWriteIndex");
    private static final AtomicIntegerFieldUpdater<RakNetSession> unackedBytesUpdater = AtomicIntegerFieldUpdater.newUpdater(RakNetSession.class, "unackedBytes");
    final InetSocketAddress address;
    private final Channel channel;
    private final ChannelPromise voidPromise;
    int mtu;
    long guid;
    private volatile RakNetState state = RakNetState.UNCONNECTED;
    private volatile long lastTouched = System.currentTimeMillis();
    private RakNetSessionListener listener = null;
    private RakNetSlidingWindow slidingWindow;
    private volatile int splitIndex = 1;
    private volatile int datagramReadIndex;
    private volatile int datagramWriteIndex;
    private Lock reliabilityReadLock;
    private int reliabilityReadIndex;
    private volatile int reliabilityWriteIndex;
    private AtomicIntegerArray orderReadIndex;
    private AtomicIntegerArray orderWriteIndex;
    private AtomicIntegerArray sequenceReadIndex;
    private AtomicIntegerArray sequenceWriteIndex;
    private RoundRobinArray<SplitPacketHelper> splitPackets;
    private BitQueue reliableDatagramQueue;
    private FastBinaryMinHeap<EncapsulatedPacket> outgoingPackets;
    private long[] outgoingPacketNextWeights;
    private FastBinaryMinHeap<EncapsulatedPacket>[] orderingHeaps;
    private volatile boolean closed = false;
    private volatile long currentPingTime = -1L;
    private volatile long lastPingTime = -1L;
    private volatile long lastPongTime = -1L;
    private RoundRobinArray<RakNetDatagram> sentDatagrams;
    private Queue<RakNetDatagram> resendQueue;
    private volatile int unackedBytes;
    private volatile long lastMinWeight;

    RakNetSession(InetSocketAddress address, Channel channel, int mtu) {
        this.address = address;
        this.channel = channel;
        this.mtu = mtu;
        this.voidPromise = channel.voidPromise();
    }

    final void initialize() {
        Preconditions.checkState((this.state == RakNetState.INITIALIZING ? 1 : 0) != 0);
        this.slidingWindow = new RakNetSlidingWindow(this.mtu);
        this.reliableDatagramQueue = new BitQueue(512);
        this.reliabilityReadLock = new ReentrantLock(true);
        this.orderReadIndex = new AtomicIntegerArray(16);
        this.orderWriteIndex = new AtomicIntegerArray(16);
        this.sequenceReadIndex = new AtomicIntegerArray(16);
        this.sequenceWriteIndex = new AtomicIntegerArray(16);
        this.orderingHeaps = new FastBinaryMinHeap[16];
        this.splitPackets = new RoundRobinArray(32);
        this.sentDatagrams = new RoundRobinArray(512);
        for (int i = 0; i < 16; ++i) {
            this.orderingHeaps[i] = new FastBinaryMinHeap(64);
        }
        this.outgoingPackets = new FastBinaryMinHeap(8);
        this.resendQueue = new ConcurrentLinkedQueue<RakNetDatagram>();
        this.outgoingPacketNextWeights = new long[4];
        this.initHeapWeights();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getMtu() {
        return this.mtu;
    }

    public long getPing() {
        return this.lastPongTime - this.lastPingTime;
    }

    public double getRTT() {
        return this.slidingWindow.getRTT();
    }

    public ByteBuf allocateBuffer(int capacity) {
        return this.channel.alloc().directBuffer(capacity);
    }

    private void initHeapWeights() {
        for (int priorityLevel = 0; priorityLevel < 4; ++priorityLevel) {
            this.outgoingPacketNextWeights[priorityLevel] = (1 << priorityLevel) * priorityLevel + priorityLevel;
        }
    }

    private long getNextWeight(RakNetPriority priority) {
        int priorityLevel = priority.ordinal();
        long next = this.outgoingPacketNextWeights[priorityLevel];
        if (!this.outgoingPackets.isEmpty()) {
            if (next >= this.lastMinWeight) {
                next = this.lastMinWeight + (long)((1 << priorityLevel) * priorityLevel) + (long)priorityLevel;
                this.outgoingPacketNextWeights[priorityLevel] = next + (long)((1 << priorityLevel) * (priorityLevel + 1)) + (long)priorityLevel;
            }
        } else {
            this.initHeapWeights();
        }
        this.lastMinWeight = next - (long)((1 << priorityLevel) * priorityLevel) + (long)priorityLevel;
        return next;
    }

    private EncapsulatedPacket getReassembledPacket(EncapsulatedPacket splitPacket) {
        EncapsulatedPacket result;
        this.checkForClosed();
        SplitPacketHelper helper = this.splitPackets.get(splitPacket.getPartId());
        if (helper == null) {
            helper = new SplitPacketHelper(splitPacket.getPartCount());
            this.splitPackets.set(splitPacket.getPartId(), helper);
        }
        if ((result = helper.add(splitPacket, this)) != null) {
            this.splitPackets.remove(splitPacket.getPartId());
            helper.release();
        }
        return result;
    }

    void onDatagram(DatagramPacket datagram) {
        boolean rakNetDatagram;
        if (!((InetSocketAddress)datagram.sender()).equals(this.address)) {
            return;
        }
        this.touch();
        ByteBuf buffer = (ByteBuf)datagram.content();
        byte potentialFlags = buffer.readByte();
        boolean bl = rakNetDatagram = (potentialFlags & 0xFFFFFF80) != 0;
        if (rakNetDatagram) {
            if (this.state.ordinal() >= RakNetState.INITIALIZED.ordinal()) {
                if ((potentialFlags & 0x40) != 0) {
                    this.onAck(buffer);
                } else if ((potentialFlags & 0x20) != 0) {
                    this.onNak(buffer);
                } else {
                    buffer.readerIndex(0);
                    this.onRakNetDatagram(buffer);
                }
            }
        } else {
            buffer.readerIndex(0);
            this.onPacketInternal(buffer);
        }
    }

    private void onEncapsulatedInternal(EncapsulatedPacket packet) {
        ByteBuf buffer = packet.buffer;
        short packetId = buffer.readUnsignedByte();
        switch (packetId) {
            case 0: {
                this.onConnectedPing(buffer);
                break;
            }
            case 3: {
                this.onConnectedPong(buffer);
                break;
            }
            case 21: {
                this.onDisconnectionNotification();
                break;
            }
            default: {
                buffer.readerIndex(0);
                if (packetId >= 128) {
                    if (this.listener != null) {
                        this.listener.onEncapsulated(packet);
                        break;
                    }
                    log.debug("Unhandled RakNet user packet");
                    break;
                }
                this.onPacket(buffer);
            }
        }
    }

    private void onPacketInternal(ByteBuf buffer) {
        short packetId = buffer.getUnsignedByte(buffer.readerIndex());
        buffer.readerIndex(0);
        if (packetId >= 128) {
            if (this.listener != null) {
                this.listener.onDirect(buffer);
            } else {
                log.debug("Unhandled RakNet user packet");
            }
        } else {
            this.onPacket(buffer);
        }
    }

    protected abstract void onPacket(ByteBuf var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRakNetDatagram(ByteBuf buffer) {
        if (this.state == RakNetState.DISCONNECTED) {
            return;
        }
        RakNetDatagram datagram = new RakNetDatagram(System.currentTimeMillis());
        datagram.decode(buffer);
        this.slidingWindow.onPacketReceived(datagram.sendTime);
        int missedDatagrams = datagram.sequenceIndex - datagramReadIndexUpdater.getAndAccumulate(this, datagram.sequenceIndex, (prev, newIndex) -> newIndex + 1);
        if (missedDatagrams > 0) {
            this.sendNack(new IntRange[]{new IntRange(datagram.sequenceIndex - missedDatagrams, datagram.sequenceIndex)});
        }
        this.sendAck(new IntRange[]{new IntRange(datagram.sequenceIndex, datagram.sequenceIndex)});
        for (EncapsulatedPacket encapsulated : datagram.packets) {
            block18: {
                if (encapsulated.reliability.isReliable()) {
                    this.reliabilityReadLock.lock();
                    try {
                        int missed = encapsulated.reliabilityIndex - this.reliabilityReadIndex;
                        if (missed > 0) {
                            if (missed < this.reliableDatagramQueue.size()) {
                                if (!this.reliableDatagramQueue.get(missed)) continue;
                                this.reliableDatagramQueue.set(missed, false);
                            } else {
                                int count = missed - this.reliableDatagramQueue.size();
                                for (int i = 0; i < count; ++i) {
                                    this.reliableDatagramQueue.add(true);
                                }
                                this.reliableDatagramQueue.add(false);
                            }
                            break block18;
                        }
                        if (missed != 0) continue;
                        ++this.reliabilityReadIndex;
                        if (this.reliableDatagramQueue.isEmpty()) break block18;
                        this.reliableDatagramQueue.poll();
                    }
                    finally {
                        this.reliabilityReadLock.unlock();
                        continue;
                    }
                }
            }
            if (encapsulated.split) {
                EncapsulatedPacket reassembled = this.getReassembledPacket(encapsulated);
                try {
                    if (reassembled == null) continue;
                    this.checkForOrdered(reassembled);
                    continue;
                }
                finally {
                    if (reassembled != null) {
                        reassembled.release();
                    }
                    continue;
                }
            }
            this.checkForOrdered(encapsulated);
        }
    }

    private void checkForOrdered(EncapsulatedPacket packet) {
        if (packet.getReliability().isOrdered()) {
            this.onOrderedReceived(packet);
        } else {
            this.onEncapsulatedInternal(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOrderedReceived(EncapsulatedPacket packet) {
        EncapsulatedPacket queuedPacket;
        FastBinaryMinHeap<EncapsulatedPacket> binaryHeap = this.orderingHeaps[packet.orderingChannel];
        if (this.orderReadIndex.get(packet.orderingChannel) < packet.orderingIndex) {
            packet.retain();
            binaryHeap.insert(packet.orderingIndex, packet);
            return;
        }
        if (this.orderReadIndex.get(packet.orderingChannel) > packet.orderingIndex) {
            return;
        }
        this.orderReadIndex.incrementAndGet(packet.orderingChannel);
        this.onEncapsulatedInternal(packet);
        while ((queuedPacket = binaryHeap.peek()) != null) {
            if (queuedPacket.orderingIndex != this.orderReadIndex.get(packet.orderingChannel)) continue;
            binaryHeap.remove();
            this.orderReadIndex.incrementAndGet(packet.orderingChannel);
            try {
                this.onEncapsulatedInternal(queuedPacket);
            }
            finally {
                queuedPacket.release();
            }
        }
    }

    final void onTick(long curTime) {
        if (this.closed) {
            return;
        }
        this.tick(curTime);
    }

    protected void tick(long curTime) {
        if (this.isTimedOut()) {
            this.close(DisconnectReason.TIMED_OUT);
            return;
        }
        if (this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
            return;
        }
        if (this.currentPingTime + 2000L < curTime) {
            this.sendConnectedPing(curTime);
        }
        this.sendQueued(curTime);
    }

    private void sendQueued(long curTime) {
        int transmissionBandwidth;
        RakNetDatagram datagram;
        int size;
        for (transmissionBandwidth = this.slidingWindow.getRetransmissionBandwidth(this.unackedBytes); (datagram = this.resendQueue.peek()) != null && transmissionBandwidth >= (size = datagram.getSize()); transmissionBandwidth -= size) {
            this.sendDatagram(datagram.retain());
            this.resendQueue.remove();
        }
        if (datagram != null) {
            this.slidingWindow.onResend(curTime);
        }
        if (!this.outgoingPackets.isEmpty()) {
            int size2;
            EncapsulatedPacket packet;
            transmissionBandwidth = this.slidingWindow.getTransmissionBandwidth(this.unackedBytes);
            datagram = new RakNetDatagram(curTime);
            while ((packet = this.outgoingPackets.peek()) != null && transmissionBandwidth >= (size2 = packet.getSize())) {
                transmissionBandwidth -= size2;
                this.outgoingPackets.remove();
                if (packet.reliability.isReliable()) {
                    packet.reliabilityIndex = reliabilityWriteIndexUpdater.getAndIncrement(this);
                }
                unackedBytesUpdater.addAndGet(this, packet.getSize());
                if (datagram.tryAddPacket(packet, this.mtu)) continue;
                this.sendDatagram(datagram);
                datagram = new RakNetDatagram(curTime);
                if (datagram.tryAddPacket(packet, this.mtu)) continue;
                throw new IllegalArgumentException("Packet too large to fit in MTU (size: " + packet.getSize() + ", MTU: " + this.mtu + ")");
            }
            if (!datagram.packets.isEmpty()) {
                this.sendDatagram(datagram);
            }
        }
        this.channel.flush();
    }

    public void disconnect() {
        this.disconnect(DisconnectReason.DISCONNECTED);
    }

    public void disconnect(DisconnectReason reason) {
        if (this.isClosed()) {
            return;
        }
        this.sendDisconnectionNotification();
        this.close(reason);
    }

    public void close() {
        this.close(DisconnectReason.DISCONNECTED);
    }

    public void close(DisconnectReason reason) {
        this.checkForClosed();
        this.closed = true;
        this.state = RakNetState.UNCONNECTED;
        this.onClose();
        log.trace("RakNet Session ({} => {}) closed: {}", new Object[]{this.getRakNet().bindAddress, this.address, reason});
        if (this.splitPackets != null) {
            this.splitPackets.forEach(ReferenceCountUtil::release);
        }
        if (this.sentDatagrams != null) {
            this.sentDatagrams.forEach(ReferenceCountUtil::release);
        }
        if (this.listener != null) {
            this.listener.onDisconnect(reason);
        }
    }

    protected void onClose() {
    }

    public void sendImmediate(ByteBuf buf) {
        this.send(buf, RakNetPriority.IMMEDIATE);
    }

    public void send(ByteBuf buf) {
        this.send(buf, RakNetPriority.MEDIUM);
    }

    public void send(ByteBuf buf, RakNetPriority priority) {
        this.send(buf, priority, RakNetReliability.RELIABLE_ORDERED);
    }

    public void send(ByteBuf buf, RakNetReliability reliability) {
        this.send(buf, RakNetPriority.MEDIUM, reliability);
    }

    public void send(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability) {
        this.send(buf, priority, reliability, 0);
    }

    public void send(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability, @Nonnegative int orderingChannel) {
        if (this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
            return;
        }
        if (priority == RakNetPriority.IMMEDIATE) {
            this.sendImmediate(buf, reliability, orderingChannel);
            return;
        }
        EncapsulatedPacket[] packets = this.createEncapsulated(buf, priority, reliability, orderingChannel);
        long weight = this.getNextWeight(priority);
        if (packets.length == 1) {
            this.outgoingPackets.insert(weight, packets[0]);
        } else {
            this.outgoingPackets.insertSeries(weight, (EncapsulatedPacket[])packets);
        }
    }

    private void sendImmediate(ByteBuf buf, RakNetReliability reliability, @Nonnegative int orderingChannel) {
        EncapsulatedPacket[] packets = this.createEncapsulated(buf, RakNetPriority.IMMEDIATE, reliability, orderingChannel);
        long curTime = System.currentTimeMillis();
        for (EncapsulatedPacket packet : packets) {
            RakNetDatagram datagram = new RakNetDatagram(curTime);
            if (packet.reliability.isReliable()) {
                packet.reliabilityIndex = reliabilityWriteIndexUpdater.getAndIncrement(this);
            }
            if (!datagram.tryAddPacket(packet, this.mtu)) {
                throw new IllegalArgumentException("Packet too large to fit in MTU (size: " + packet.getSize() + ", MTU: " + this.mtu + ")");
            }
            this.sendDatagram(datagram);
        }
        this.channel.flush();
    }

    private EncapsulatedPacket[] createEncapsulated(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability, int orderingChannel) {
        ByteBuf[] bufs;
        int maxLength = this.mtu - 28 - 23;
        int splitId = 0;
        if (buf.readableBytes() > maxLength) {
            switch (reliability) {
                case UNRELIABLE: {
                    reliability = RakNetReliability.RELIABLE;
                    break;
                }
                case UNRELIABLE_SEQUENCED: {
                    reliability = RakNetReliability.RELIABLE_SEQUENCED;
                    break;
                }
                case UNRELIABLE_WITH_ACK_RECEIPT: {
                    reliability = RakNetReliability.RELIABLE_WITH_ACK_RECEIPT;
                }
            }
            int split = (buf.readableBytes() - 1) / maxLength + 1;
            bufs = new ByteBuf[split];
            buf.retain(split - 1);
            for (int i = 0; i < split; ++i) {
                bufs[i] = buf.readSlice(Math.min(maxLength, buf.readableBytes()));
            }
            splitId = splitIndexUpdater.getAndIncrement(this);
        } else {
            bufs = new ByteBuf[]{buf};
        }
        int orderingIndex = 0;
        if (reliability.isOrdered()) {
            orderingIndex = this.orderWriteIndex.getAndIncrement(orderingChannel);
        }
        EncapsulatedPacket[] packets = new EncapsulatedPacket[bufs.length];
        int parts = bufs.length;
        for (int i = 0; i < parts; ++i) {
            EncapsulatedPacket packet = new EncapsulatedPacket();
            packet.buffer = bufs[i];
            packet.orderingChannel = (short)orderingChannel;
            packet.orderingIndex = orderingIndex;
            packet.reliability = reliability;
            packet.priority = priority;
            if (parts > 1) {
                packet.split = true;
                packet.partIndex = i;
                packet.partCount = parts;
                packet.partId = splitId;
            }
            packets[i] = packet;
        }
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDatagram(RakNetDatagram datagram) {
        try {
            RakNetDatagram sentDatagram;
            if (datagram.sequenceIndex == -1) {
                datagram.sequenceIndex = datagramWriteIndexUpdater.getAndIncrement(this);
            }
            if ((sentDatagram = this.sentDatagrams.get(datagram.sequenceIndex)) == null || sentDatagram.sequenceIndex < datagram.sequenceIndex) {
                for (EncapsulatedPacket packet : datagram.packets) {
                    if (packet.reliability == RakNetReliability.UNRELIABLE || packet.reliability == RakNetReliability.UNRELIABLE_SEQUENCED) continue;
                    this.sentDatagrams.set(datagram.sequenceIndex, datagram.retain());
                    break;
                }
            }
            Preconditions.checkArgument((!datagram.packets.isEmpty() ? 1 : 0) != 0, (Object)"RakNetDatagram with no packets");
            ByteBuf buf = this.channel.alloc().directBuffer();
            datagram.encode(buf);
            this.channel.write((Object)new DatagramPacket(buf, this.address), this.voidPromise);
        }
        finally {
            datagram.release();
        }
    }

    void sendDirect(ByteBuf buffer) {
        this.channel.writeAndFlush((Object)new DatagramPacket(buffer, this.address), this.voidPromise);
    }

    private void onAck(ByteBuf buffer) {
        IntRange[] acked;
        this.checkForClosed();
        for (IntRange range : acked = RakNetUtils.readIntRanges(buffer)) {
            for (int i = range.start; i <= range.end; ++i) {
                RakNetDatagram datagram = this.sentDatagrams.remove(i);
                if (datagram == null || datagram.sequenceIndex != i) continue;
                unackedBytesUpdater.addAndGet(this, -datagram.getSize());
                datagram.release();
                this.slidingWindow.onAck(System.currentTimeMillis() - datagram.sendTime, datagram.sequenceIndex, this.datagramReadIndex);
            }
        }
    }

    private void onNak(ByteBuf buffer) {
        IntRange[] acked;
        this.checkForClosed();
        for (IntRange range : acked = RakNetUtils.readIntRanges(buffer)) {
            for (int i = range.start; i <= range.end; ++i) {
                RakNetDatagram datagram = this.sentDatagrams.get(i);
                if (datagram == null || datagram.sequenceIndex != i) continue;
                log.trace("Resending datagram {} after NAK to {}", (Object)datagram.sequenceIndex, (Object)this.address);
                this.slidingWindow.onNak();
                this.resendQueue.offer(datagram.retain());
            }
        }
        this.channel.flush();
    }

    private void onConnectedPing(ByteBuf buffer) {
        long pingTime = buffer.readLong();
        this.sendConnectedPong(pingTime);
    }

    private void onConnectedPong(ByteBuf buffer) {
        long pingTime = buffer.readLong();
        if (this.currentPingTime == pingTime) {
            this.lastPingTime = this.currentPingTime;
            this.lastPongTime = System.currentTimeMillis();
        }
    }

    private void onDisconnectionNotification() {
        this.close(DisconnectReason.CLOSED_BY_REMOTE_PEER);
    }

    private void sendConnectedPing(long pingTime) {
        ByteBuf buffer = this.allocateBuffer(9);
        buffer.writeByte(0);
        buffer.writeLong(pingTime);
        this.send(buffer, RakNetPriority.IMMEDIATE);
        this.currentPingTime = pingTime;
    }

    private void sendConnectedPong(long pingTime) {
        ByteBuf buffer = this.allocateBuffer(17);
        buffer.writeByte(3);
        buffer.writeLong(pingTime);
        buffer.writeLong(System.currentTimeMillis());
        this.send(buffer, RakNetPriority.IMMEDIATE);
    }

    private void sendDisconnectionNotification() {
        ByteBuf buffer = this.allocateBuffer(1);
        buffer.writeByte(21);
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.RELIABLE_ORDERED);
    }

    private void sendDetectLostConnection() {
        ByteBuf buffer = this.allocateBuffer(1);
        buffer.writeByte(4);
        this.send(buffer, RakNetPriority.IMMEDIATE);
    }

    private void sendAck(IntRange[] toAck) {
        int length = 3;
        for (IntRange range : toAck) {
            length += range.start == range.end ? 4 : 7;
        }
        ByteBuf buffer = this.allocateBuffer(length);
        buffer.writeByte(-64);
        RakNetUtils.writeIntRanges(buffer, toAck);
        this.sendDirect(buffer);
    }

    private void sendNack(IntRange[] toNack) {
        int length = 3;
        for (IntRange range : toNack) {
            length += range.start == range.end ? 4 : 7;
        }
        ByteBuf buffer = this.allocateBuffer(length);
        buffer.writeByte(-96);
        RakNetUtils.writeIntRanges(buffer, toNack);
        this.sendDirect(buffer);
    }

    private void touch() {
        this.checkForClosed();
        this.lastTouched = System.currentTimeMillis();
    }

    public boolean isStale() {
        return System.currentTimeMillis() - this.lastTouched >= 5000L;
    }

    public boolean isTimedOut() {
        return System.currentTimeMillis() - this.lastTouched >= 30000L;
    }

    private void checkForClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Session already closed");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public abstract RakNet getRakNet();

    boolean isIpv6Session() {
        return this.address.getAddress() instanceof Inet6Address;
    }

    public RakNetState getState() {
        return this.state;
    }

    void setState(RakNetState state) {
        if (this.state != state) {
            this.state = state;
            if (this.listener != null) {
                this.listener.onSessionChangeState(this.state);
            }
        }
    }

    public RakNetSessionListener getListener() {
        return this.listener;
    }

    public void setListener(RakNetSessionListener listener) {
        this.listener = listener;
    }
}

