/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.BootstrapUtils;
import com.nukkitx.network.NetworkServer;
import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetServerListener;
import com.nukkitx.network.raknet.RakNetServerSession;
import com.nukkitx.network.raknet.RakNetState;
import com.nukkitx.network.raknet.RakNetUtils;
import com.nukkitx.network.raknet.util.RoundRobinIterator;
import com.nukkitx.network.util.DisconnectReason;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RakNetServer
extends RakNet
implements NetworkServer<RakNetServerSession> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetServer.class);
    final ConcurrentMap<InetSocketAddress, RakNetServerSession> sessionsByAddress = new ConcurrentHashMap<InetSocketAddress, RakNetServerSession>();
    private final ServerDatagramHandler datagramHandler = new ServerDatagramHandler();
    private final ConcurrentMap<InetAddress, Long> blockAddresses = new ConcurrentHashMap<InetAddress, Long>();
    private final Set<Channel> channels = new HashSet<Channel>();
    private final Iterator<Channel> channelIterator = new RoundRobinIterator<Channel>(this.channels);
    private RakNetServerListener listener = null;
    private final int maxThreads;
    private int maxConnections = 1024;

    public RakNetServer(InetSocketAddress bindAddress) {
        this(bindAddress, 1);
    }

    public RakNetServer(InetSocketAddress bindAddress, int maxThreads) {
        this(bindAddress, maxThreads, Executors.newSingleThreadScheduledExecutor());
    }

    public RakNetServer(InetSocketAddress bindAddress, int maxThreads, ScheduledExecutorService scheduler) {
        this(bindAddress, maxThreads, scheduler, scheduler);
    }

    public RakNetServer(InetSocketAddress bindAddress, int maxThreads, ScheduledExecutorService scheduler, Executor executor) {
        super(bindAddress, scheduler, executor);
        this.maxThreads = maxThreads;
    }

    @Override
    protected CompletableFuture<Void> bindInternal() {
        int threads = BootstrapUtils.isReusePortAvailable() ? this.maxThreads : 1;
        ChannelFuture[] channelFutures = new ChannelFuture[threads];
        for (int i = 0; i < threads; ++i) {
            channelFutures[i] = ((Bootstrap)this.bootstrap.handler((ChannelHandler)this.datagramHandler)).bind((SocketAddress)this.bindAddress);
        }
        return BootstrapUtils.allOf((ChannelFuture[])channelFutures);
    }

    public void block(InetAddress address) {
        Objects.requireNonNull(address, "address");
        this.blockAddresses.put(address, -1L);
    }

    public void block(InetAddress address, long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(address, "timeUnit");
        this.blockAddresses.put(address, System.currentTimeMillis() + timeUnit.toMillis(timeout));
    }

    public boolean unblock(InetAddress address) {
        Objects.requireNonNull(address, "address");
        return this.blockAddresses.remove(address) != null;
    }

    public int getSessionCount() {
        return this.sessionsByAddress.size();
    }

    @Nullable
    public RakNetServerSession getSession(InetSocketAddress address) {
        return (RakNetServerSession)this.sessionsByAddress.get(address);
    }

    @Nonnegative
    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(@Nonnegative int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public RakNetServerListener getListener() {
        return this.listener;
    }

    public void setListener(RakNetServerListener listener) {
        this.listener = listener;
    }

    public void send(InetSocketAddress address, ByteBuf buffer) {
        this.channelIterator.next().writeAndFlush((Object)new DatagramPacket(buffer, address));
    }

    @Override
    public void close() {
        super.close();
        for (RakNetServerSession session : this.sessionsByAddress.values()) {
            session.disconnect(DisconnectReason.SHUTTING_DOWN);
        }
        for (Channel channel : this.channels) {
            channel.close().syncUninterruptibly();
        }
    }

    @Override
    protected void onTick() {
        long curTime = System.currentTimeMillis();
        for (RakNetServerSession session : this.sessionsByAddress.values()) {
            this.executor.execute(() -> session.onTick(curTime));
        }
        Iterator blockedAddresses = this.blockAddresses.values().iterator();
        while (blockedAddresses.hasNext()) {
            long timeout = (Long)blockedAddresses.next();
            if (timeout <= 0L || timeout >= curTime) continue;
            blockedAddresses.remove();
        }
    }

    private void onOpenConnectionRequest1(ChannelHandlerContext ctx, DatagramPacket packet) {
        ByteBuf buffer = (ByteBuf)packet.content();
        if (!RakNetUtils.verifyUnconnectedMagic(buffer)) {
            return;
        }
        short protocolVersion = buffer.readUnsignedByte();
        int mtu = RakNetUtils.clamp(buffer.readableBytes() + 18, 576, 1464);
        RakNetServerSession session = (RakNetServerSession)this.sessionsByAddress.get(packet.sender());
        if (session != null) {
            this.sendAlreadyConnected(ctx, (InetSocketAddress)packet.sender());
        } else if (this.protocolVersion >= 0 && this.protocolVersion != protocolVersion) {
            this.sendIncompatibleProtocolVersion(ctx, (InetSocketAddress)packet.sender());
        } else if (this.maxConnections <= this.getSessionCount()) {
            this.sendNoFreeIncomingConnections(ctx, (InetSocketAddress)packet.sender());
        } else if (this.listener != null && !this.listener.onConnectionRequest((InetSocketAddress)packet.sender())) {
            this.sendConnectionBanned(ctx, (InetSocketAddress)packet.sender());
        } else {
            session = new RakNetServerSession(this, (InetSocketAddress)packet.sender(), ctx.channel(), mtu);
            session.setState(RakNetState.INITIALIZING);
            if (this.sessionsByAddress.putIfAbsent((InetSocketAddress)packet.sender(), session) == null) {
                session.sendOpenConnectionReply1();
                if (this.listener != null) {
                    this.listener.onSessionCreation(session);
                }
            }
        }
    }

    private void onUnconnectedPing(ChannelHandlerContext ctx, DatagramPacket packet) {
        long pingTime = ((ByteBuf)packet.content()).readLong();
        byte[] userData = null;
        if (this.listener != null) {
            userData = this.listener.onQuery((InetSocketAddress)packet.sender());
        }
        if (userData == null) {
            userData = new byte[]{};
        }
        int packetLength = 35 + userData.length;
        ByteBuf buffer = ctx.alloc().directBuffer(packetLength, packetLength);
        buffer.writeByte(28);
        buffer.writeLong(pingTime);
        buffer.writeLong(this.guid);
        RakNetUtils.writeUnconnectedMagic(buffer);
        buffer.writeShort(userData.length);
        buffer.writeBytes(userData);
        RakNet.send(ctx, (InetSocketAddress)packet.sender(), buffer);
    }

    private void sendAlreadyConnected(ChannelHandlerContext ctx, InetSocketAddress recipient) {
        ByteBuf buffer = ctx.alloc().directBuffer(25, 25);
        buffer.writeByte(18);
        RakNetUtils.writeUnconnectedMagic(buffer);
        buffer.writeLong(this.guid);
        RakNet.send(ctx, recipient, buffer);
    }

    private void sendConnectionBanned(ChannelHandlerContext ctx, InetSocketAddress recipient) {
        ByteBuf buffer = ctx.alloc().directBuffer(25, 25);
        buffer.writeByte(23);
        RakNetUtils.writeUnconnectedMagic(buffer);
        buffer.writeLong(this.guid);
        RakNet.send(ctx, recipient, buffer);
    }

    private void sendIncompatibleProtocolVersion(ChannelHandlerContext ctx, InetSocketAddress recipient) {
        ByteBuf buffer = ctx.alloc().directBuffer(26, 26);
        buffer.writeByte(25);
        buffer.writeByte(this.protocolVersion);
        RakNetUtils.writeUnconnectedMagic(buffer);
        buffer.writeLong(this.guid);
        RakNet.send(ctx, recipient, buffer);
    }

    private void sendNoFreeIncomingConnections(ChannelHandlerContext ctx, InetSocketAddress recipient) {
        ByteBuf buffer = ctx.alloc().directBuffer(25, 25);
        buffer.writeByte(20);
        RakNetUtils.writeUnconnectedMagic(buffer);
        buffer.writeLong(this.guid);
        RakNet.send(ctx, recipient, buffer);
    }

    @ChannelHandler.Sharable
    private class ServerDatagramHandler
    extends ChannelInboundHandlerAdapter {
        private ServerDatagramHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (!(msg instanceof DatagramPacket)) {
                return;
            }
            DatagramPacket packet = (DatagramPacket)msg;
            try {
                if (RakNetServer.this.blockAddresses.containsKey(((InetSocketAddress)packet.sender()).getAddress())) {
                    return;
                }
                ByteBuf content = (ByteBuf)packet.content();
                byte packetId = content.readByte();
                switch (packetId) {
                    case 1: {
                        RakNetServer.this.onUnconnectedPing(ctx, packet);
                        return;
                    }
                    case 5: {
                        RakNetServer.this.onOpenConnectionRequest1(ctx, packet);
                        return;
                    }
                }
                content.readerIndex(0);
                RakNetServerSession session = (RakNetServerSession)RakNetServer.this.sessionsByAddress.get(packet.sender());
                if (session != null) {
                    session.onDatagram(packet);
                }
                if (RakNetServer.this.listener != null) {
                    RakNetServer.this.listener.onUnhandledDatagram(ctx, packet);
                }
            }
            finally {
                packet.release();
            }
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            if (ctx.channel().isRegistered()) {
                RakNetServer.this.channels.add(ctx.channel());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("An exception occurred in RakNet", cause);
        }
    }
}

