/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.raknet.EncapsulatedPacket;
import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class RakNetDatagram
extends AbstractReferenceCounted {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetDatagram.class);
    final List<EncapsulatedPacket> packets = new ArrayList<EncapsulatedPacket>();
    final long sendTime;
    byte flags = (byte)-128;
    int sequenceIndex = -1;

    public RakNetDatagram retain() {
        super.retain();
        return this;
    }

    public RakNetDatagram retain(int increment) {
        super.retain(increment);
        return this;
    }

    public RakNetDatagram touch(Object hint) {
        for (EncapsulatedPacket packet : this.packets) {
            packet.touch(hint);
        }
        return this;
    }

    public void decode(ByteBuf buf) {
        this.flags = buf.readByte();
        this.sequenceIndex = buf.readUnsignedMediumLE();
        while (buf.isReadable()) {
            EncapsulatedPacket packet = new EncapsulatedPacket();
            packet.decode(buf);
            this.packets.add(packet);
        }
    }

    public void encode(ByteBuf buf) {
        buf.writeByte((int)this.flags);
        buf.writeMediumLE(this.sequenceIndex);
        for (EncapsulatedPacket packet : this.packets) {
            packet.encode(buf);
        }
    }

    boolean tryAddPacket(EncapsulatedPacket packet, int mtu) {
        int packetLn = packet.getSize();
        if (packetLn >= mtu - 23) {
            return false;
        }
        int existingLn = 0;
        for (EncapsulatedPacket netPacket : this.packets) {
            existingLn += netPacket.getSize();
        }
        if (existingLn + packetLn >= mtu - 23) {
            return false;
        }
        this.packets.add(packet);
        if (packet.split) {
            this.flags = (byte)(this.flags | 8);
        }
        return true;
    }

    public boolean release() {
        return super.release();
    }

    protected void deallocate() {
        for (EncapsulatedPacket packet : this.packets) {
            packet.release();
        }
    }

    public int getSize() {
        int size = 1;
        for (EncapsulatedPacket packet : this.packets) {
            size += packet.getSize();
        }
        return size;
    }

    public RakNetDatagram(long sendTime) {
        this.sendTime = sendTime;
    }

    public List<EncapsulatedPacket> getPackets() {
        return this.packets;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public void setSequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    public String toString() {
        return "RakNetDatagram(packets=" + this.getPackets() + ", sendTime=" + this.getSendTime() + ", flags=" + this.getFlags() + ", sequenceIndex=" + this.getSequenceIndex() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RakNetDatagram)) {
            return false;
        }
        RakNetDatagram other = (RakNetDatagram)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<EncapsulatedPacket> this$packets = this.getPackets();
        List<EncapsulatedPacket> other$packets = other.getPackets();
        if (this$packets == null ? other$packets != null : !((Object)this$packets).equals(other$packets)) {
            return false;
        }
        if (this.getSendTime() != other.getSendTime()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        return this.getSequenceIndex() == other.getSequenceIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RakNetDatagram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<EncapsulatedPacket> $packets = this.getPackets();
        result = result * 59 + ($packets == null ? 43 : ((Object)$packets).hashCode());
        long $sendTime = this.getSendTime();
        result = result * 59 + (int)($sendTime >>> 32 ^ $sendTime);
        result = result * 59 + this.getFlags();
        result = result * 59 + this.getSequenceIndex();
        return result;
    }
}

