/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.NetworkClient;
import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetClientSession;
import com.nukkitx.network.raknet.RakNetPong;
import com.nukkitx.network.raknet.RakNetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RakNetClient
extends RakNet
implements NetworkClient<RakNetClientSession> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetClient.class);
    private final ClientDatagramHandler handler = new ClientDatagramHandler();
    private final ConcurrentMap<InetSocketAddress, PingEntry> pings = new ConcurrentHashMap<InetSocketAddress, PingEntry>();
    RakNetClientSession session;
    private Channel channel;

    public RakNetClient(InetSocketAddress bindAddress) {
        this(bindAddress, Executors.newSingleThreadScheduledExecutor());
    }

    public RakNetClient(InetSocketAddress bindAddress, ScheduledExecutorService scheduler) {
        this(bindAddress, scheduler, scheduler);
    }

    public RakNetClient(InetSocketAddress bindAddress, ScheduledExecutorService scheduler, Executor executor) {
        super(bindAddress, scheduler, executor);
    }

    @Override
    protected CompletableFuture<Void> bindInternal() {
        ChannelFuture channelFuture = ((Bootstrap)this.bootstrap.handler((ChannelHandler)this.handler)).bind((SocketAddress)this.bindAddress);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        channelFuture.addListener(future1 -> {
            if (future1.cause() != null) {
                future.completeExceptionally(future1.cause());
            }
            future.complete(null);
        });
        return future;
    }

    public RakNetClientSession connect(InetSocketAddress address) {
        if (!this.isRunning()) {
            throw new IllegalStateException("RakNet has not been started");
        }
        if (this.session != null) {
            throw new IllegalStateException("Session has already been created");
        }
        this.session = new RakNetClientSession(this, address, this.channel, 1464);
        return this.session;
    }

    public CompletableFuture<RakNetPong> ping(InetSocketAddress address, long timeout, TimeUnit unit) {
        if (!this.isRunning()) {
            throw new IllegalStateException("RakNet has not been started");
        }
        if (this.session != null && this.session.address.equals(address)) {
            throw new IllegalArgumentException("Cannot ping connected address");
        }
        if (this.pings.containsKey(address)) {
            return ((PingEntry)this.pings.get(address)).future;
        }
        CompletableFuture<RakNetPong> pongFuture = new CompletableFuture<RakNetPong>();
        PingEntry entry = new PingEntry(pongFuture, System.currentTimeMillis() + unit.toMillis(timeout));
        this.pings.put(address, entry);
        this.sendUnconnectedPing(address);
        return pongFuture;
    }

    @Override
    protected void onTick() {
        long curTime = System.currentTimeMillis();
        if (this.session != null) {
            this.executor.execute(() -> this.session.onTick(curTime));
        }
        Iterator iterator = this.pings.values().iterator();
        while (iterator.hasNext()) {
            PingEntry entry = (PingEntry)iterator.next();
            if (curTime < entry.timeout) continue;
            entry.future.completeExceptionally(new TimeoutException());
            iterator.remove();
        }
    }

    private void onUnconnectedPong(DatagramPacket packet) {
        PingEntry entry = (PingEntry)this.pings.get(packet.sender());
        if (entry == null) {
            return;
        }
        ByteBuf content = (ByteBuf)packet.content();
        long pingTime = content.readLong();
        long guid = content.readLong();
        if (!RakNetUtils.verifyUnconnectedMagic(content)) {
            return;
        }
        byte[] userData = null;
        if (content.isReadable()) {
            userData = new byte[content.readUnsignedShort()];
            content.readBytes(userData);
        }
        entry.future.complete(new RakNetPong(pingTime, System.currentTimeMillis(), guid, userData));
    }

    private void sendUnconnectedPing(InetSocketAddress recipient) {
        ByteBuf buffer = this.channel.alloc().directBuffer(9);
        buffer.writeByte(1);
        buffer.writeLong(System.currentTimeMillis());
        RakNetUtils.writeUnconnectedMagic(buffer);
        buffer.writeLong(this.guid);
        this.channel.writeAndFlush((Object)new DatagramPacket(buffer, recipient));
    }

    private class ClientDatagramHandler
    extends ChannelInboundHandlerAdapter {
        private ClientDatagramHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (!(msg instanceof DatagramPacket)) {
                return;
            }
            DatagramPacket packet = (DatagramPacket)msg;
            try {
                ByteBuf content = (ByteBuf)packet.content();
                short packetId = content.readUnsignedByte();
                if (packetId == 28) {
                    RakNetClient.this.onUnconnectedPong(packet);
                } else if (RakNetClient.this.session != null) {
                    content.readerIndex(0);
                    RakNetClient.this.session.onDatagram(packet);
                }
            }
            finally {
                packet.release();
            }
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            if (ctx.channel().isRegistered()) {
                RakNetClient.this.channel = ctx.channel();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("An exception occurred in RakNet", cause);
        }
    }

    private static class PingEntry {
        private final CompletableFuture<RakNetPong> future;
        private final long timeout;

        public PingEntry(CompletableFuture<RakNetPong> future, long timeout) {
            this.future = future;
            this.timeout = timeout;
        }
    }
}

