/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.BootstrapUtils;
import com.nukkitx.network.NetworkInterface;
import com.nukkitx.network.util.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RakNet
implements NetworkInterface,
AutoCloseable {
    final long guid = ThreadLocalRandom.current().nextLong();
    final Bootstrap bootstrap;
    final Executor executor;
    final InetSocketAddress bindAddress;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ScheduledFuture<?> tickFuture;
    int protocolVersion = 9;
    private volatile boolean closed;

    RakNet(InetSocketAddress bindAddress, ScheduledExecutorService scheduler, Executor executor) {
        this.bindAddress = bindAddress;
        this.executor = executor;
        this.bootstrap = (Bootstrap)new Bootstrap().option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        BootstrapUtils.setupBootstrap((Bootstrap)this.bootstrap, (boolean)true);
        this.tickFuture = scheduler.scheduleAtFixedRate(this::onTick, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    static void send(ChannelHandlerContext ctx, InetSocketAddress recipient, ByteBuf buffer) {
        ctx.writeAndFlush((Object)new DatagramPacket(buffer, recipient), ctx.voidPromise());
    }

    public CompletableFuture<Void> bind() {
        Preconditions.checkState((boolean)this.running.compareAndSet(false, true), (Object)"RakNet has already been started");
        CompletableFuture<Void> future = this.bindInternal();
        future.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.running.compareAndSet(true, false);
            }
        });
        return future;
    }

    @Override
    public void close() {
        this.tickFuture.cancel(false);
        this.closed = true;
    }

    protected abstract CompletableFuture<Void> bindInternal();

    protected abstract void onTick();

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Nonnegative
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(@Nonnegative int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public long getGuid() {
        return this.guid;
    }
}

