/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.raknet.RakNetPriority;
import com.nukkitx.network.raknet.RakNetReliability;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;

public class EncapsulatedPacket
implements ReferenceCounted {
    RakNetReliability reliability;
    RakNetPriority priority;
    int reliabilityIndex;
    int sequenceIndex;
    int orderingIndex;
    short orderingChannel;
    boolean split;
    long partCount;
    int partId;
    long partIndex;
    ByteBuf buffer;

    public void encode(ByteBuf buf) {
        int flags = this.reliability.ordinal() << 5;
        if (this.split) {
            flags |= 0x10;
        }
        buf.writeByte(flags);
        buf.writeShort(this.buffer.readableBytes() << 3);
        if (this.reliability.isReliable()) {
            buf.writeMediumLE(this.reliabilityIndex);
        }
        if (this.reliability.isSequenced()) {
            buf.writeMediumLE(this.sequenceIndex);
        }
        if (this.reliability.isOrdered() || this.reliability.isSequenced()) {
            buf.writeMediumLE(this.orderingIndex);
            buf.writeByte((int)this.orderingChannel);
        }
        if (this.split) {
            buf.writeInt((int)this.partCount);
            buf.writeShort(this.partId);
            buf.writeInt((int)this.partIndex);
        }
        buf.writeBytes(this.buffer);
    }

    public void decode(ByteBuf buf) {
        byte flags = buf.readByte();
        this.reliability = RakNetReliability.fromId((flags & 0xE0) >> 5);
        this.split = (flags & 0x10) != 0;
        short size = (short)Math.ceil((double)buf.readShort() / 8.0);
        if (this.reliability.isReliable()) {
            this.reliabilityIndex = buf.readUnsignedMediumLE();
        }
        if (this.reliability.isSequenced()) {
            this.sequenceIndex = buf.readUnsignedMediumLE();
        }
        if (this.reliability.isOrdered() || this.reliability.isSequenced()) {
            this.orderingIndex = buf.readUnsignedMediumLE();
            this.orderingChannel = buf.readUnsignedByte();
        }
        if (this.split) {
            this.partCount = buf.readUnsignedInt();
            this.partId = buf.readUnsignedShort();
            this.partIndex = buf.readUnsignedInt();
        }
        this.buffer = buf.readSlice((int)size);
    }

    public int getSize() {
        int size = 3 + this.reliability.getSize();
        if (this.split) {
            size += 10;
        }
        return size += this.buffer.readableBytes();
    }

    public EncapsulatedPacket fromSplit(ByteBuf reassembled) {
        EncapsulatedPacket packet = new EncapsulatedPacket();
        packet.reliability = this.reliability;
        packet.reliabilityIndex = this.reliabilityIndex;
        packet.sequenceIndex = this.sequenceIndex;
        packet.orderingIndex = this.orderingIndex;
        packet.orderingChannel = this.orderingChannel;
        packet.buffer = reassembled;
        return packet;
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public ReferenceCounted retain() {
        return this.buffer.retain();
    }

    public ReferenceCounted retain(int i) {
        return this.buffer.retain(i);
    }

    public ReferenceCounted touch() {
        return this.buffer.touch();
    }

    public ReferenceCounted touch(Object o) {
        return this.buffer.touch(o);
    }

    public boolean release() {
        return this.buffer.release();
    }

    public boolean release(int i) {
        return this.buffer.release(i);
    }

    public RakNetReliability getReliability() {
        return this.reliability;
    }

    public RakNetPriority getPriority() {
        return this.priority;
    }

    public int getReliabilityIndex() {
        return this.reliabilityIndex;
    }

    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public int getOrderingIndex() {
        return this.orderingIndex;
    }

    public short getOrderingChannel() {
        return this.orderingChannel;
    }

    public boolean isSplit() {
        return this.split;
    }

    public long getPartCount() {
        return this.partCount;
    }

    public int getPartId() {
        return this.partId;
    }

    public long getPartIndex() {
        return this.partIndex;
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncapsulatedPacket)) {
            return false;
        }
        EncapsulatedPacket other = (EncapsulatedPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RakNetReliability this$reliability = this.getReliability();
        RakNetReliability other$reliability = other.getReliability();
        if (this$reliability == null ? other$reliability != null : !((Object)((Object)this$reliability)).equals((Object)other$reliability)) {
            return false;
        }
        RakNetPriority this$priority = this.getPriority();
        RakNetPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)((Object)this$priority)).equals((Object)other$priority)) {
            return false;
        }
        if (this.getReliabilityIndex() != other.getReliabilityIndex()) {
            return false;
        }
        if (this.getSequenceIndex() != other.getSequenceIndex()) {
            return false;
        }
        if (this.getOrderingIndex() != other.getOrderingIndex()) {
            return false;
        }
        if (this.getOrderingChannel() != other.getOrderingChannel()) {
            return false;
        }
        if (this.isSplit() != other.isSplit()) {
            return false;
        }
        if (this.getPartCount() != other.getPartCount()) {
            return false;
        }
        if (this.getPartId() != other.getPartId()) {
            return false;
        }
        if (this.getPartIndex() != other.getPartIndex()) {
            return false;
        }
        ByteBuf this$buffer = this.getBuffer();
        ByteBuf other$buffer = other.getBuffer();
        return !(this$buffer == null ? other$buffer != null : !this$buffer.equals(other$buffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncapsulatedPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RakNetReliability $reliability = this.getReliability();
        result = result * 59 + ($reliability == null ? 43 : ((Object)((Object)$reliability)).hashCode());
        RakNetPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)((Object)$priority)).hashCode());
        result = result * 59 + this.getReliabilityIndex();
        result = result * 59 + this.getSequenceIndex();
        result = result * 59 + this.getOrderingIndex();
        result = result * 59 + this.getOrderingChannel();
        result = result * 59 + (this.isSplit() ? 79 : 97);
        long $partCount = this.getPartCount();
        result = result * 59 + (int)($partCount >>> 32 ^ $partCount);
        result = result * 59 + this.getPartId();
        long $partIndex = this.getPartIndex();
        result = result * 59 + (int)($partIndex >>> 32 ^ $partIndex);
        ByteBuf $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : $buffer.hashCode());
        return result;
    }

    public String toString() {
        return "EncapsulatedPacket(reliability=" + (Object)((Object)this.getReliability()) + ", priority=" + (Object)((Object)this.getPriority()) + ", reliabilityIndex=" + this.getReliabilityIndex() + ", sequenceIndex=" + this.getSequenceIndex() + ", orderingIndex=" + this.getOrderingIndex() + ", orderingChannel=" + this.getOrderingChannel() + ", split=" + this.isSplit() + ", partCount=" + this.getPartCount() + ", partId=" + this.getPartId() + ", partIndex=" + this.getPartIndex() + ", buffer=" + this.getBuffer() + ")";
    }
}

