/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.query;

import com.nukkitx.network.NetworkListener;
import com.nukkitx.network.query.QueryEventListener;
import com.nukkitx.network.query.codec.QueryPacketCodec;
import com.nukkitx.network.query.handler.QueryPacketHandler;
import com.nukkitx.network.util.Bootstraps;
import com.nukkitx.network.util.EventLoops;
import com.nukkitx.network.util.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class QueryNetworkListener
extends ChannelInitializer<DatagramChannel>
implements NetworkListener {
    private final InetSocketAddress address;
    private final QueryEventListener eventListener;
    private final Bootstrap bootstrap;
    private DatagramChannel channel;

    public QueryNetworkListener(InetSocketAddress address, QueryEventListener eventListener) {
        this.address = address;
        this.eventListener = eventListener;
        this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().option(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT)).handler((ChannelHandler)this);
        Bootstraps.setupBootstrap((Bootstrap)this.bootstrap, (boolean)true);
        this.bootstrap.group(EventLoops.commonGroup());
    }

    public boolean bind() {
        Preconditions.checkState((this.channel == null ? 1 : 0) != 0, (Object)"Channel already initialized");
        ChannelFuture future = this.bootstrap.bind((SocketAddress)this.address).awaitUninterruptibly();
        return future.isSuccess();
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close().syncUninterruptibly();
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    protected void initChannel(DatagramChannel datagramChannel) throws Exception {
        this.channel = datagramChannel;
        this.channel.pipeline().addLast("queryPacketCodec", (ChannelHandler)new QueryPacketCodec()).addLast("queryPacketHandler", (ChannelHandler)new QueryPacketHandler(this.eventListener));
    }
}

