/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.query.codec;

import com.nukkitx.network.query.QueryPacket;
import com.nukkitx.network.query.enveloped.DirectAddressedQueryPacket;
import com.nukkitx.network.query.packet.HandshakePacket;
import com.nukkitx.network.query.packet.StatisticsPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;

public class QueryPacketCodec
extends MessageToMessageCodec<DatagramPacket, DirectAddressedQueryPacket> {
    private static final byte[] QUERY_SIGNATURE = new byte[]{-2, -3};
    private static final int HANDSHAKE = 9;
    private static final short STATISTICS = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext channelHandlerContext, DirectAddressedQueryPacket packet, List<Object> list) throws Exception {
        try {
            ByteBuf buf = PooledByteBufAllocator.DEFAULT.directBuffer();
            buf.writeByte(((QueryPacket)packet.content()).getId() & 0xFF);
            ((QueryPacket)packet.content()).encode(buf);
            list.add(new DatagramPacket(buf, (InetSocketAddress)packet.recipient(), (InetSocketAddress)packet.sender()));
        }
        finally {
            packet.release();
        }
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, DatagramPacket packet, List<Object> list) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        if (buf.readableBytes() < 3) {
            return;
        }
        buf.markReaderIndex();
        byte[] prefix = new byte[2];
        buf.readBytes(prefix);
        if (Arrays.equals(prefix, QUERY_SIGNATURE)) {
            QueryPacket networkPacket;
            short id = buf.readUnsignedByte();
            switch (id) {
                case 9: {
                    networkPacket = new HandshakePacket();
                    break;
                }
                case 0: {
                    networkPacket = new StatisticsPacket();
                    break;
                }
                default: {
                    buf.resetReaderIndex();
                    return;
                }
            }
            networkPacket.decode(buf);
            list.add((Object)new DirectAddressedQueryPacket(networkPacket, (InetSocketAddress)packet.recipient(), (InetSocketAddress)packet.sender()));
        } else {
            buf.resetReaderIndex();
        }
    }
}

