/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.query.packet;

import com.nukkitx.network.query.QueryPacket;
import com.nukkitx.network.query.QueryUtil;
import io.netty.buffer.ByteBuf;

public class HandshakePacket
implements QueryPacket {
    private static final short ID = 9;
    private int sessionId;
    private String token;

    public void decode(ByteBuf buffer) {
        this.sessionId = buffer.readInt();
    }

    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.sessionId);
        QueryUtil.writeNullTerminatedString(buffer, this.token);
    }

    @Override
    public short getId() {
        return 9;
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandshakePacket)) {
            return false;
        }
        HandshakePacket other = (HandshakePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSessionId() != other.getSessionId()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HandshakePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSessionId();
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "HandshakePacket(sessionId=" + this.getSessionId() + ", token=" + this.getToken() + ")";
    }
}

