/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.query.packet;

import com.nukkitx.network.query.QueryPacket;
import io.netty.buffer.ByteBuf;

public class StatisticsPacket
implements QueryPacket {
    private static final short ID = 0;
    private int sessionId;
    private int token;
    private boolean full;
    private ByteBuf payload;

    public void decode(ByteBuf buffer) {
        this.sessionId = buffer.readInt();
        this.token = buffer.readInt();
        this.full = buffer.isReadable();
        buffer.skipBytes(buffer.readableBytes());
    }

    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.sessionId);
        buffer.writeBytes(this.payload);
    }

    @Override
    public short getId() {
        return 0;
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    public int getToken() {
        return this.token;
    }

    public boolean isFull() {
        return this.full;
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    @Override
    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public void setToken(int token) {
        this.token = token;
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsPacket)) {
            return false;
        }
        StatisticsPacket other = (StatisticsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSessionId() != other.getSessionId()) {
            return false;
        }
        if (this.getToken() != other.getToken()) {
            return false;
        }
        if (this.isFull() != other.isFull()) {
            return false;
        }
        ByteBuf this$payload = this.getPayload();
        ByteBuf other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSessionId();
        result = result * 59 + this.getToken();
        result = result * 59 + (this.isFull() ? 79 : 97);
        ByteBuf $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    public String toString() {
        return "StatisticsPacket(sessionId=" + this.getSessionId() + ", token=" + this.getToken() + ", full=" + this.isFull() + ", payload=" + this.getPayload() + ")";
    }
}

