/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.query;

import com.nukkitx.network.query.QueryUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringJoiner;

public interface QueryEventListener {
    public Data onQuery(InetSocketAddress var1);

    public static final class Data {
        private final String hostname;
        private final String gametype;
        private final String map;
        private final int playerCount;
        private final int maxPlayerCount;
        private final int hostport;
        private final String hostip;
        private final String gameId;
        private final String version;
        private final String softwareVersion;
        private final boolean whitelisted;
        private final String[] plugins;
        private final String[] players;
        private transient ByteBuf longStats;
        private transient ByteBuf shortStats;

        public ByteBuf getLongStats() {
            if (this.longStats != null) {
                return this.longStats;
            }
            this.longStats = PooledByteBufAllocator.DEFAULT.buffer();
            this.longStats.writeBytes(QueryUtil.LONG_RESPONSE_PADDING_TOP);
            StringJoiner plugins = new StringJoiner(";");
            if (this.plugins != null) {
                for (String plugin : this.plugins) {
                    plugins.add(plugin);
                }
            }
            HashMap<String, String> kvs = new HashMap<String, String>();
            kvs.put("hostname", this.hostname);
            kvs.put("gametype", this.gametype);
            kvs.put("map", this.map);
            kvs.put("numplayers", Integer.toString(this.playerCount));
            kvs.put("maxplayers", Integer.toString(this.maxPlayerCount));
            kvs.put("hostport", Integer.toString(this.hostport));
            kvs.put("hostip", this.hostip);
            kvs.put("game_id", this.gameId);
            kvs.put("version", this.version);
            kvs.put("plugins", this.softwareVersion + plugins.toString());
            kvs.put("whitelist", this.whitelisted ? "on" : "off");
            kvs.forEach((key, value) -> {
                QueryUtil.writeNullTerminatedString(this.longStats, key);
                QueryUtil.writeNullTerminatedString(this.longStats, value);
            });
            this.longStats.writeByte(0);
            this.longStats.writeBytes(QueryUtil.LONG_RESPONSE_PADDING_BOTTOM);
            if (this.players != null) {
                for (String player : this.players) {
                    QueryUtil.writeNullTerminatedString(this.longStats, player);
                }
            }
            this.longStats.writeByte(0);
            return this.longStats;
        }

        public ByteBuf getShortStats() {
            if (this.shortStats != null) {
                return this.shortStats;
            }
            this.shortStats = PooledByteBufAllocator.DEFAULT.buffer();
            QueryUtil.writeNullTerminatedString(this.shortStats, this.hostname);
            QueryUtil.writeNullTerminatedString(this.shortStats, this.gametype);
            QueryUtil.writeNullTerminatedString(this.shortStats, this.map);
            QueryUtil.writeNullTerminatedString(this.shortStats, Integer.toString(this.playerCount));
            QueryUtil.writeNullTerminatedString(this.shortStats, Integer.toString(this.maxPlayerCount));
            this.shortStats.writeShortLE(this.hostport);
            QueryUtil.writeNullTerminatedString(this.shortStats, this.hostip);
            return this.shortStats;
        }

        public Data(String hostname, String gametype, String map, int playerCount, int maxPlayerCount, int hostport, String hostip, String gameId, String version, String softwareVersion, boolean whitelisted, String[] plugins, String[] players, ByteBuf longStats, ByteBuf shortStats) {
            this.hostname = hostname;
            this.gametype = gametype;
            this.map = map;
            this.playerCount = playerCount;
            this.maxPlayerCount = maxPlayerCount;
            this.hostport = hostport;
            this.hostip = hostip;
            this.gameId = gameId;
            this.version = version;
            this.softwareVersion = softwareVersion;
            this.whitelisted = whitelisted;
            this.plugins = plugins;
            this.players = players;
            this.longStats = longStats;
            this.shortStats = shortStats;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getGametype() {
            return this.gametype;
        }

        public String getMap() {
            return this.map;
        }

        public int getPlayerCount() {
            return this.playerCount;
        }

        public int getMaxPlayerCount() {
            return this.maxPlayerCount;
        }

        public int getHostport() {
            return this.hostport;
        }

        public String getHostip() {
            return this.hostip;
        }

        public String getGameId() {
            return this.gameId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSoftwareVersion() {
            return this.softwareVersion;
        }

        public boolean isWhitelisted() {
            return this.whitelisted;
        }

        public String[] getPlugins() {
            return this.plugins;
        }

        public String[] getPlayers() {
            return this.players;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            String this$gametype = this.getGametype();
            String other$gametype = other.getGametype();
            if (this$gametype == null ? other$gametype != null : !this$gametype.equals(other$gametype)) {
                return false;
            }
            String this$map = this.getMap();
            String other$map = other.getMap();
            if (this$map == null ? other$map != null : !this$map.equals(other$map)) {
                return false;
            }
            if (this.getPlayerCount() != other.getPlayerCount()) {
                return false;
            }
            if (this.getMaxPlayerCount() != other.getMaxPlayerCount()) {
                return false;
            }
            if (this.getHostport() != other.getHostport()) {
                return false;
            }
            String this$hostip = this.getHostip();
            String other$hostip = other.getHostip();
            if (this$hostip == null ? other$hostip != null : !this$hostip.equals(other$hostip)) {
                return false;
            }
            String this$gameId = this.getGameId();
            String other$gameId = other.getGameId();
            if (this$gameId == null ? other$gameId != null : !this$gameId.equals(other$gameId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$softwareVersion = this.getSoftwareVersion();
            String other$softwareVersion = other.getSoftwareVersion();
            if (this$softwareVersion == null ? other$softwareVersion != null : !this$softwareVersion.equals(other$softwareVersion)) {
                return false;
            }
            if (this.isWhitelisted() != other.isWhitelisted()) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPlugins(), other.getPlugins())) {
                return false;
            }
            return Arrays.deepEquals(this.getPlayers(), other.getPlayers());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            String $gametype = this.getGametype();
            result = result * 59 + ($gametype == null ? 43 : $gametype.hashCode());
            String $map = this.getMap();
            result = result * 59 + ($map == null ? 43 : $map.hashCode());
            result = result * 59 + this.getPlayerCount();
            result = result * 59 + this.getMaxPlayerCount();
            result = result * 59 + this.getHostport();
            String $hostip = this.getHostip();
            result = result * 59 + ($hostip == null ? 43 : $hostip.hashCode());
            String $gameId = this.getGameId();
            result = result * 59 + ($gameId == null ? 43 : $gameId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $softwareVersion = this.getSoftwareVersion();
            result = result * 59 + ($softwareVersion == null ? 43 : $softwareVersion.hashCode());
            result = result * 59 + (this.isWhitelisted() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.getPlugins());
            result = result * 59 + Arrays.deepHashCode(this.getPlayers());
            return result;
        }

        public String toString() {
            return "QueryEventListener.Data(hostname=" + this.getHostname() + ", gametype=" + this.getGametype() + ", map=" + this.getMap() + ", playerCount=" + this.getPlayerCount() + ", maxPlayerCount=" + this.getMaxPlayerCount() + ", hostport=" + this.getHostport() + ", hostip=" + this.getHostip() + ", gameId=" + this.getGameId() + ", version=" + this.getVersion() + ", softwareVersion=" + this.getSoftwareVersion() + ", whitelisted=" + this.isWhitelisted() + ", plugins=" + Arrays.deepToString(this.getPlugins()) + ", players=" + Arrays.deepToString(this.getPlayers()) + ", longStats=" + this.getLongStats() + ", shortStats=" + this.getShortStats() + ")";
        }
    }
}

