/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.util;

import com.nukkitx.network.util.NetworkThreadFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

public final class EventLoops {
    static final ChannelType CHANNEL_TYPE;
    static final EventLoopGroup EVENT_LOOP_GROUP;
    private static final ThreadFactory EVENT_LOOP_FACTORY;

    public static EventLoopGroup commonGroup() {
        return EVENT_LOOP_GROUP;
    }

    public static EventLoopGroup newEventLoopGroup(int threads) {
        return (EventLoopGroup)CHANNEL_TYPE.eventLoopGroupFactory.apply(threads);
    }

    public static ChannelType getChannelType() {
        return CHANNEL_TYPE;
    }

    private EventLoops() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        EVENT_LOOP_FACTORY = NetworkThreadFactory.builder().format("Network Listener - #%d").daemon(true).build();
        boolean disableNative = System.getProperties().contains("disableNativeEventLoop");
        CHANNEL_TYPE = Epoll.isAvailable() && !disableNative ? ChannelType.EPOLL : (KQueue.isAvailable() && !disableNative ? ChannelType.KQUEUE : ChannelType.NIO);
        EVENT_LOOP_GROUP = (EventLoopGroup)CHANNEL_TYPE.eventLoopGroupFactory.apply(0);
    }

    public static enum ChannelType {
        EPOLL(EpollDatagramChannel.class, EpollSocketChannel.class, EpollServerSocketChannel.class, threads -> new EpollEventLoopGroup(threads.intValue(), EVENT_LOOP_FACTORY)),
        KQUEUE(KQueueDatagramChannel.class, KQueueSocketChannel.class, KQueueServerSocketChannel.class, threads -> new KQueueEventLoopGroup(threads.intValue(), EVENT_LOOP_FACTORY)),
        NIO(NioDatagramChannel.class, NioSocketChannel.class, NioServerSocketChannel.class, threads -> new NioEventLoopGroup(threads.intValue(), EVENT_LOOP_FACTORY));

        final Class<? extends DatagramChannel> datagramChannel;
        final Class<? extends SocketChannel> socketChannel;
        final Class<? extends ServerSocketChannel> serverSocketChannel;
        private final Function<Integer, EventLoopGroup> eventLoopGroupFactory;

        public Class<? extends DatagramChannel> getDatagramChannel() {
            return this.datagramChannel;
        }

        public Class<? extends ServerSocketChannel> getServerSocketChannel() {
            return this.serverSocketChannel;
        }

        public Class<? extends SocketChannel> getSocketChannel() {
            return this.socketChannel;
        }

        private ChannelType(Class<? extends DatagramChannel> datagramChannel, Class<? extends SocketChannel> socketChannel, Class<? extends ServerSocketChannel> serverSocketChannel, Function<Integer, EventLoopGroup> eventLoopGroupFactory) {
            this.datagramChannel = datagramChannel;
            this.socketChannel = socketChannel;
            this.serverSocketChannel = serverSocketChannel;
            this.eventLoopGroupFactory = eventLoopGroupFactory;
        }
    }
}

