/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network;

import io.netty.buffer.ByteBuf;

public final class VarInts {
    public static void writeInt(ByteBuf buffer, int value) {
        VarInts.encode(buffer, (long)(value << 1 ^ value >> 31) & 0xFFFFFFFFL);
    }

    public static int readInt(ByteBuf buffer) {
        int n = (int)VarInts.decode(buffer);
        return n >>> 1 ^ -(n & 1);
    }

    public static void writeUnsignedInt(ByteBuf buffer, int value) {
        VarInts.encode(buffer, (long)value & 0xFFFFFFFFL);
    }

    public static int readUnsignedInt(ByteBuf buffer) {
        return (int)VarInts.decode(buffer);
    }

    public static void writeLong(ByteBuf buffer, long value) {
        VarInts.encode(buffer, value << 1 ^ value >> 63);
    }

    public static long readLong(ByteBuf buffer) {
        long n = VarInts.decode(buffer);
        return n >>> 1 ^ -(n & 1L);
    }

    public static void writeUnsignedLong(ByteBuf buffer, long value) {
        VarInts.encode(buffer, value);
    }

    public static long readUnsignedLong(ByteBuf buffer) {
        return VarInts.decode(buffer);
    }

    private static long decode(ByteBuf buffer) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer.readByte();
            result |= ((long)b & 0x7FL) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ArithmeticException("Varint was too large");
    }

    private static void encode(ByteBuf buffer, long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.writeByte((int)value);
                return;
            }
            buffer.writeByte((int)((byte)((int)value & 0x7F | 0x80)));
            value >>>= 7;
        }
    }

    private VarInts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

