/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt;

import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtType;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;

public class NBTInputStream
implements Closeable {
    private final DataInput input;
    private boolean closed = false;

    public NBTInputStream(DataInput input) {
        this.input = Objects.requireNonNull(input, "input");
    }

    public Object readTag() throws IOException {
        return this.readTag(16);
    }

    public Object readTag(int maxDepth) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Trying to read from a closed reader!");
        }
        int typeId = this.input.readUnsignedByte();
        NbtType<?> type = NbtType.byId(typeId);
        this.input.readUTF();
        return this.deserialize(type, maxDepth);
    }

    private Object deserialize(NbtType<?> type, int maxDepth) throws IOException {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("NBT compound is too deeply nested");
        }
        switch (type.getEnum()) {
            case END: {
                return null;
            }
            case BYTE: {
                return this.input.readByte();
            }
            case SHORT: {
                return this.input.readShort();
            }
            case INT: {
                return this.input.readInt();
            }
            case LONG: {
                return this.input.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.input.readFloat());
            }
            case DOUBLE: {
                return this.input.readDouble();
            }
            case BYTE_ARRAY: {
                int arraySize = this.input.readInt();
                byte[] bytes = new byte[arraySize];
                this.input.readFully(bytes);
                return bytes;
            }
            case STRING: {
                return this.input.readUTF();
            }
            case COMPOUND: {
                NbtType<?> nbtType;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                while ((nbtType = NbtType.byId(this.input.readUnsignedByte())) != NbtType.END) {
                    String name = this.input.readUTF();
                    map.put(name, this.deserialize(nbtType, maxDepth - 1));
                }
                return new NbtMap(map);
            }
            case LIST: {
                int typeId = this.input.readUnsignedByte();
                NbtType<?> listType = NbtType.byId(typeId);
                ArrayList<Object> list = new ArrayList<Object>();
                int listLength = this.input.readInt();
                for (int i = 0; i < listLength; ++i) {
                    list.add(this.deserialize(listType, maxDepth - 1));
                }
                return new NbtList(listType, (Collection<?>)list);
            }
            case INT_ARRAY: {
                int arraySize = this.input.readInt();
                int[] ints = new int[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    ints[i] = this.input.readInt();
                }
                return ints;
            }
            case LONG_ARRAY: {
                int arraySize = this.input.readInt();
                long[] longs = new long[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    longs[i] = this.input.readLong();
                }
                return longs;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.input instanceof Closeable) {
            ((Closeable)((Object)this.input)).close();
        }
    }
}

