/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt.tag;

import javax.annotation.Nonnull;

public abstract class Tag<T>
implements Comparable<Tag<T>> {
    private final String name;

    public Tag(String name) {
        this.name = name;
    }

    public abstract T getValue();

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(@Nonnull Tag other) {
        if (this.equals(other)) {
            return 0;
        }
        if (other.getName().equals(this.getName())) {
            throw new IllegalStateException("Cannot compare two Tags with the same name but different values for sorting");
        }
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        String append = ": ";
        if (this.name != null && !this.name.isEmpty()) {
            append = "(\"" + this.getName() + "\")" + append;
        }
        return append;
    }
}

