/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt.tag;

import com.nukkitx.nbt.tag.Tag;
import java.util.Objects;

public class FloatTag
extends Tag<Float> {
    private final float value;

    public FloatTag(String name, float value) {
        super(name);
        this.value = value;
    }

    public float getPrimitiveValue() {
        return this.value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), Float.valueOf(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatTag that = (FloatTag)o;
        return this.value == that.value && Objects.equals(this.getName(), that.getName());
    }

    @Override
    public String toString() {
        return "TAG_Float" + super.toString() + this.value;
    }
}

