/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt.tag;

import com.nukkitx.nbt.CompoundTagBuilder;
import com.nukkitx.nbt.tag.ByteArrayTag;
import com.nukkitx.nbt.tag.ByteTag;
import com.nukkitx.nbt.tag.DoubleTag;
import com.nukkitx.nbt.tag.FloatTag;
import com.nukkitx.nbt.tag.IntArrayTag;
import com.nukkitx.nbt.tag.IntTag;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.LongArrayTag;
import com.nukkitx.nbt.tag.LongTag;
import com.nukkitx.nbt.tag.ShortTag;
import com.nukkitx.nbt.tag.StringTag;
import com.nukkitx.nbt.tag.Tag;
import com.nukkitx.nbt.util.function.BooleanConsumer;
import com.nukkitx.nbt.util.function.ByteConsumer;
import com.nukkitx.nbt.util.function.FloatConsumer;
import com.nukkitx.nbt.util.function.ShortConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public class CompoundTag
extends Tag<Map<String, Tag<?>>> {
    public static final CompoundTag EMPTY = new CompoundTag("", Collections.emptyMap());
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final Map<String, Tag<?>> value;

    public CompoundTag(String name, Map<String, Tag<?>> value) {
        super(name);
        this.value = Collections.unmodifiableMap(new HashMap(Objects.requireNonNull(value, "value")));
    }

    public static CompoundTag createFromList(String name, List<Tag<?>> list) {
        HashMap map = new HashMap();
        for (Tag<?> tag : list) {
            if (tag.getName() == null || tag.getName().isEmpty()) {
                throw new IllegalArgumentException("Tag " + tag + " does not have a name.");
            }
            map.put(tag.getName(), tag);
        }
        return new CompoundTag(name, map);
    }

    @Override
    public Map<String, Tag<?>> getValue() {
        return this.value;
    }

    public CompoundTagBuilder toBuilder() {
        return CompoundTagBuilder.from(this);
    }

    public boolean contains(String key) {
        return this.value.containsKey(key);
    }

    @Nullable
    public <T extends Tag<?>> T get(String key) {
        return (T)this.value.get(key);
    }

    public boolean getAsBoolean(String key) {
        return this.getAsBoolean(key, false);
    }

    public boolean getAsBoolean(String key, boolean defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getAsBoolean();
        }
        return defaultValue;
    }

    public void listenForBoolean(String key, BooleanConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            consumer.accept(((ByteTag)tag).getAsBoolean());
        }
    }

    public byte getAsByte(String key) {
        return this.getAsByte(key, (byte)0);
    }

    public byte getAsByte(String key, byte defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getPrimitiveValue();
        }
        return defaultValue;
    }

    public void listenForByte(String key, ByteConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ByteTag) {
            consumer.accept(((ByteTag)tag).getPrimitiveValue());
        }
    }

    public short getAsShort(String key) {
        return this.getAsShort(key, (short)0);
    }

    public short getAsShort(String key, short defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).getPrimitiveValue();
        }
        return defaultValue;
    }

    public void listenForShort(String key, ShortConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ShortTag) {
            consumer.accept(((ShortTag)tag).getPrimitiveValue());
        }
    }

    public int getAsInt(String key) {
        return this.getAsInt(key, 0);
    }

    public int getAsInt(String key, int defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof IntTag) {
            return ((IntTag)tag).getPrimitiveValue();
        }
        return defaultValue;
    }

    public void listenForInt(String key, IntConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof IntTag) {
            consumer.accept(((IntTag)tag).getPrimitiveValue());
        }
    }

    public long getAsLong(String key) {
        return this.getAsLong(key, 0L);
    }

    public long getAsLong(String key, long defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof LongTag) {
            return ((LongTag)tag).getPrimitiveValue();
        }
        return defaultValue;
    }

    public void listenForLong(String key, LongConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof LongTag) {
            consumer.accept(((LongTag)tag).getPrimitiveValue());
        }
    }

    public float getAsFloat(String key) {
        return this.getAsFloat(key, 0.0f);
    }

    public float getAsFloat(String key, float defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).getPrimitiveValue();
        }
        return defaultValue;
    }

    public void listenForFloat(String key, FloatConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof FloatTag) {
            consumer.accept(((FloatTag)tag).getPrimitiveValue());
        }
    }

    public double getAsDouble(String key) {
        return this.getAsDouble(key, 0.0);
    }

    public double getAsDouble(String key, double defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).getPrimitiveValue();
        }
        return defaultValue;
    }

    public void listenForDouble(String key, DoubleConsumer consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof DoubleTag) {
            consumer.accept(((DoubleTag)tag).getPrimitiveValue());
        }
    }

    public String getAsString(String key) {
        return this.getAsString(key, "");
    }

    public String getAsString(String key, @Nullable String defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof StringTag) {
            return ((StringTag)tag).getValue();
        }
        return defaultValue;
    }

    public void listenForString(String key, Consumer<String> consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof StringTag) {
            consumer.accept(((StringTag)tag).getValue());
        }
    }

    public byte[] getAsByteArray(String key) {
        return this.getAsByteArray(key, EMPTY_BYTE_ARRAY);
    }

    public byte[] getAsByteArray(String key, @Nullable byte[] defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ByteArrayTag) {
            return ((ByteArrayTag)tag).getValue();
        }
        return defaultValue;
    }

    public void listenForByteArray(String key, Consumer<byte[]> consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ByteArrayTag) {
            consumer.accept(((ByteArrayTag)tag).getValue());
        }
    }

    public int[] getAsIntArray(String key) {
        return this.getAsIntArray(key, EMPTY_INT_ARRAY);
    }

    public int[] getAsIntArray(String key, @Nullable int[] defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof IntArrayTag) {
            return ((IntArrayTag)tag).getValue();
        }
        return defaultValue;
    }

    public void listenForIntArray(String key, Consumer<int[]> consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof IntArrayTag) {
            consumer.accept(((IntArrayTag)tag).getValue());
        }
    }

    public long[] getAsLongArray(String key) {
        return this.getAsLongArray(key, EMPTY_LONG_ARRAY);
    }

    public long[] getAsLongArray(String key, @Nullable long[] defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof LongArrayTag) {
            return ((LongArrayTag)tag).getValue();
        }
        return defaultValue;
    }

    public void listenForLongArray(String key, Consumer<long[]> consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof LongArrayTag) {
            consumer.accept(((LongArrayTag)tag).getValue());
        }
    }

    public CompoundTag getAsCompound(String key) {
        return this.getAsCompound(key, EMPTY);
    }

    public CompoundTag getAsCompound(String key, @Nullable CompoundTag defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        return defaultValue;
    }

    public void listenForCompound(String key, Consumer<CompoundTag> consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof CompoundTag) {
            consumer.accept((CompoundTag)tag);
        }
    }

    public <T extends Tag<?>> List<T> getAsList(String key, Class<T> tagClass) {
        return this.getAsList(key, tagClass, Collections.emptyList());
    }

    public <T extends Tag<?>> List<T> getAsList(String key, Class<T> tagClass, @Nullable List<T> defaultValue) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ListTag && ((ListTag)tag).getTagClass() == tagClass) {
            return ((ListTag)tag).getValue();
        }
        return defaultValue;
    }

    public <T extends Tag<?>> void listenForList(String key, Class<T> tagClass, Consumer<List<T>> consumer) {
        Tag<?> tag = this.value.get(key);
        if (tag instanceof ListTag && ((ListTag)tag).getTagClass() == tagClass) {
            consumer.accept((List<Object>)((ListTag)tag).getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundTag that = (CompoundTag)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TAG_Compound").append(super.toString()).append(this.value.size()).append(" entries\r\n(\r\n");
        for (Tag<?> entry : this.value.values()) {
            builder.append("   ").append(entry.toString().replaceAll("\r\n", "\r\n   ")).append("\r\n");
        }
        builder.append(")");
        return builder.toString();
    }
}

