/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt.stream;

import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.TagType;
import com.nukkitx.nbt.tag.ByteArrayTag;
import com.nukkitx.nbt.tag.ByteTag;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.nbt.tag.DoubleTag;
import com.nukkitx.nbt.tag.FloatTag;
import com.nukkitx.nbt.tag.IntArrayTag;
import com.nukkitx.nbt.tag.IntTag;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.LongArrayTag;
import com.nukkitx.nbt.tag.LongTag;
import com.nukkitx.nbt.tag.ShortTag;
import com.nukkitx.nbt.tag.StringTag;
import com.nukkitx.nbt.tag.Tag;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class NBTOutputStream
implements Closeable {
    private final DataOutput output;
    private boolean closed = false;

    public NBTOutputStream(DataOutput output) {
        this.output = Objects.requireNonNull(output, "output");
    }

    public void write(Tag<?> tag) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Objects.requireNonNull(tag, "tag");
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalArgumentException("Trying to write a non-compound tag!");
        }
        this.serialize(tag, false, 0);
    }

    private void serialize(Tag<?> tag, boolean skipHeader, int depth) throws IOException {
        if (depth >= NbtUtils.MAX_DEPTH) {
            throw new IllegalArgumentException("Reached depth limit");
        }
        TagType type = TagType.byClass(tag.getClass());
        if (type == null) {
            throw new IllegalArgumentException("Tag " + tag + " is not valid.");
        }
        if (!skipHeader) {
            this.output.writeByte(type.ordinal() & 0xFF);
            this.output.writeUTF(tag.getName());
        }
        switch (type) {
            case END: {
                break;
            }
            case BYTE: {
                ByteTag bt = (ByteTag)tag;
                this.output.writeByte(bt.getPrimitiveValue());
                break;
            }
            case SHORT: {
                ShortTag st = (ShortTag)tag;
                this.output.writeShort(st.getPrimitiveValue());
                break;
            }
            case INT: {
                IntTag it = (IntTag)tag;
                this.output.writeInt(it.getPrimitiveValue());
                break;
            }
            case LONG: {
                LongTag lt = (LongTag)tag;
                this.output.writeLong(lt.getPrimitiveValue());
                break;
            }
            case FLOAT: {
                FloatTag ft = (FloatTag)tag;
                this.output.writeFloat(ft.getPrimitiveValue());
                break;
            }
            case DOUBLE: {
                DoubleTag dt = (DoubleTag)tag;
                this.output.writeDouble(dt.getPrimitiveValue());
                break;
            }
            case BYTE_ARRAY: {
                ByteArrayTag bat = (ByteArrayTag)tag;
                byte[] bValue = bat.getValue();
                this.output.writeInt(bValue.length);
                this.output.write(bValue);
                break;
            }
            case STRING: {
                StringTag strt = (StringTag)tag;
                this.output.writeUTF(strt.getValue());
                break;
            }
            case LIST: {
                ListTag listt = (ListTag)tag;
                this.output.writeByte(TagType.byClass(listt.getTagClass()).ordinal());
                this.output.writeInt(listt.getValue().size());
                Iterator iterator = listt.getValue().iterator();
                while (iterator.hasNext()) {
                    Tag tag1 = (Tag)iterator.next();
                    this.serialize(tag1, true, depth + 1);
                }
                break;
            }
            case COMPOUND: {
                CompoundTag compoundTag = (CompoundTag)tag;
                for (Tag tag1 : compoundTag.getValue().values()) {
                    this.serialize(tag1, false, depth + 1);
                }
                this.output.writeByte(0);
                break;
            }
            case INT_ARRAY: {
                IntArrayTag iat = (IntArrayTag)tag;
                int[] iValue = iat.getValue();
                this.output.writeInt(iValue.length);
                for (int i : iValue) {
                    this.output.writeInt(i);
                }
                break;
            }
            case LONG_ARRAY: {
                LongArrayTag lat = (LongArrayTag)tag;
                long[] longValues = lat.getValue();
                this.output.writeInt(longValues.length);
                for (long l : longValues) {
                    this.output.writeLong(l);
                }
                break;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.output instanceof Closeable) {
            ((Closeable)((Object)this.output)).close();
        }
    }
}

