/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt.stream;

import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.nbt.TagType;
import com.nukkitx.nbt.tag.ByteArrayTag;
import com.nukkitx.nbt.tag.ByteTag;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.nbt.tag.DoubleTag;
import com.nukkitx.nbt.tag.EndTag;
import com.nukkitx.nbt.tag.FloatTag;
import com.nukkitx.nbt.tag.IntArrayTag;
import com.nukkitx.nbt.tag.IntTag;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.LongArrayTag;
import com.nukkitx.nbt.tag.LongTag;
import com.nukkitx.nbt.tag.ShortTag;
import com.nukkitx.nbt.tag.StringTag;
import com.nukkitx.nbt.tag.Tag;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class NBTInputStream
implements Closeable {
    private final DataInput input;
    private boolean closed = false;

    public NBTInputStream(DataInput input) {
        this.input = Objects.requireNonNull(input, "input");
    }

    public Tag<?> readTag() throws IOException {
        return this.readTag(0);
    }

    private Tag<?> readTag(int depth) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Trying to read from a closed reader!");
        }
        int typeId = this.input.readUnsignedByte();
        TagType type = TagType.byId(typeId);
        if (type == null) {
            throw new IOException("Invalid encoding ID " + typeId);
        }
        return this.deserialize(type, false, depth);
    }

    private Tag<?> deserialize(TagType type, boolean skipName, int depth) throws IOException {
        if (depth > NbtUtils.MAX_DEPTH) {
            throw new IllegalArgumentException("NBT compound is too deeply nested");
        }
        String tagName = null;
        if (type != TagType.END && !skipName) {
            tagName = this.input.readUTF();
        }
        switch (type) {
            case END: {
                if (depth == 0) {
                    throw new IllegalArgumentException("Found a TAG_End in root tag!");
                }
                return EndTag.INSTANCE;
            }
            case BYTE: {
                return new ByteTag(tagName, this.input.readByte());
            }
            case SHORT: {
                return new ShortTag(tagName, this.input.readShort());
            }
            case INT: {
                return new IntTag(tagName, this.input.readInt());
            }
            case LONG: {
                return new LongTag(tagName, this.input.readLong());
            }
            case FLOAT: {
                return new FloatTag(tagName, this.input.readFloat());
            }
            case DOUBLE: {
                return new DoubleTag(tagName, this.input.readDouble());
            }
            case BYTE_ARRAY: {
                int arraySz1 = this.input.readInt();
                byte[] valueBytesBa = new byte[arraySz1];
                this.input.readFully(valueBytesBa);
                return new ByteArrayTag(tagName, valueBytesBa);
            }
            case STRING: {
                return new StringTag(tagName, this.input.readUTF());
            }
            case COMPOUND: {
                Tag<?> inTag1;
                HashMap map = new HashMap();
                while ((inTag1 = this.readTag(depth + 1)) != EndTag.INSTANCE) {
                    map.put(inTag1.getName(), inTag1);
                }
                return new CompoundTag(tagName, map);
            }
            case LIST: {
                int inId = this.input.readUnsignedByte();
                TagType listType = TagType.byId(inId);
                if (listType == null) {
                    String append = tagName == null ? "" : "('" + tagName + "')";
                    throw new IllegalArgumentException("Found invalid type in TAG_List" + append + ": " + inId);
                }
                ArrayList list = new ArrayList();
                int listLength = this.input.readInt();
                for (int i = 0; i < listLength; ++i) {
                    list.add(this.deserialize(listType, true, depth + 1));
                }
                return new ListTag<Tag>(tagName, listType.getTagClass(), list);
            }
            case INT_ARRAY: {
                int arraySz2 = this.input.readInt();
                int[] intValues = new int[arraySz2];
                for (int i = 0; i < arraySz2; ++i) {
                    intValues[i] = this.input.readInt();
                }
                return new IntArrayTag(tagName, intValues);
            }
            case LONG_ARRAY: {
                int arraySz3 = this.input.readInt();
                long[] longValues = new long[arraySz3];
                for (int i = 0; i < arraySz3; ++i) {
                    longValues[i] = this.input.readLong();
                }
                return new LongArrayTag(tagName, longValues);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.input instanceof Closeable) {
            ((Closeable)((Object)this.input)).close();
        }
    }
}

