/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt;

import com.nukkitx.nbt.tag.ByteArrayTag;
import com.nukkitx.nbt.tag.ByteTag;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.nbt.tag.DoubleTag;
import com.nukkitx.nbt.tag.EndTag;
import com.nukkitx.nbt.tag.FloatTag;
import com.nukkitx.nbt.tag.IntArrayTag;
import com.nukkitx.nbt.tag.IntTag;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.LongArrayTag;
import com.nukkitx.nbt.tag.LongTag;
import com.nukkitx.nbt.tag.ShortTag;
import com.nukkitx.nbt.tag.StringTag;
import com.nukkitx.nbt.tag.Tag;
import java.util.HashMap;
import java.util.Map;

public enum TagType {
    END(EndTag.class),
    BYTE(ByteTag.class),
    SHORT(ShortTag.class),
    INT(IntTag.class),
    LONG(LongTag.class),
    FLOAT(FloatTag.class),
    DOUBLE(DoubleTag.class),
    BYTE_ARRAY(ByteArrayTag.class),
    STRING(StringTag.class),
    LIST(ListTag.class),
    COMPOUND(CompoundTag.class),
    INT_ARRAY(IntArrayTag.class),
    LONG_ARRAY(LongArrayTag.class);

    private static final TagType[] BY_ID;
    private static final Map<Class<? extends Tag>, TagType> BY_CLASS;
    private final Class<? extends Tag> tagClass;

    private TagType(Class<? extends Tag> tagClass) {
        this.tagClass = tagClass;
    }

    public static TagType byId(int id) {
        if (id >= 0 && id < BY_ID.length) {
            return BY_ID[id];
        }
        throw new IndexOutOfBoundsException("Tag type id must be greater than 0 and less than " + (BY_ID.length - 1));
    }

    public static TagType byClass(Class<? extends Tag> tagClass) {
        TagType type = BY_CLASS.get(tagClass);
        if (type == null) {
            throw new IllegalArgumentException("Tag of class " + tagClass + " does not exist");
        }
        return type;
    }

    public Class<? extends Tag> getTagClass() {
        return this.tagClass;
    }

    public int getId() {
        return this.ordinal();
    }

    public String getTypeName() {
        return "TAG_" + this.name();
    }

    static {
        BY_CLASS = new HashMap<Class<? extends Tag>, TagType>();
        for (TagType type : BY_ID = TagType.values()) {
            BY_CLASS.put(type.getTagClass(), type);
        }
    }
}

