/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt;

import com.nukkitx.nbt.tag.ByteArrayTag;
import com.nukkitx.nbt.tag.ByteTag;
import com.nukkitx.nbt.tag.CompoundTag;
import com.nukkitx.nbt.tag.DoubleTag;
import com.nukkitx.nbt.tag.FloatTag;
import com.nukkitx.nbt.tag.IntArrayTag;
import com.nukkitx.nbt.tag.IntTag;
import com.nukkitx.nbt.tag.ListTag;
import com.nukkitx.nbt.tag.LongArrayTag;
import com.nukkitx.nbt.tag.LongTag;
import com.nukkitx.nbt.tag.ShortTag;
import com.nukkitx.nbt.tag.StringTag;
import com.nukkitx.nbt.tag.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompoundTagBuilder {
    private final Map<String, Tag<?>> tagMap = new HashMap();

    private CompoundTagBuilder() {
    }

    public static CompoundTagBuilder builder() {
        return new CompoundTagBuilder();
    }

    public static CompoundTagBuilder from(CompoundTag tag) {
        CompoundTagBuilder builder = new CompoundTagBuilder();
        builder.tagMap.putAll((Map<String, Tag<?>>)tag.getValue());
        return builder;
    }

    public CompoundTagBuilder tag(Tag<?> tag) {
        this.tagMap.put(tag.getName(), tag);
        return this;
    }

    public CompoundTagBuilder booleanTag(String name, boolean value) {
        return this.tag(new ByteTag(name, (byte)(value ? 1 : 0)));
    }

    public CompoundTagBuilder byteTag(String name, byte value) {
        return this.tag(new ByteTag(name, value));
    }

    public CompoundTagBuilder byteArrayTag(String name, byte[] value) {
        return this.tag(new ByteArrayTag(name, value));
    }

    public CompoundTagBuilder doubleTag(String name, double value) {
        return this.tag(new DoubleTag(name, value));
    }

    public CompoundTagBuilder floatTag(String name, float value) {
        return this.tag(new FloatTag(name, value));
    }

    public CompoundTagBuilder intArrayTag(String name, int[] value) {
        return this.tag(new IntArrayTag(name, value));
    }

    public CompoundTagBuilder longArrayTag(String name, long[] value) {
        return this.tag(new LongArrayTag(name, value));
    }

    public CompoundTagBuilder intTag(String name, int value) {
        return this.tag(new IntTag(name, value));
    }

    public CompoundTagBuilder longTag(String name, long value) {
        return this.tag(new LongTag(name, value));
    }

    public CompoundTagBuilder shortTag(String name, short value) {
        return this.tag(new ShortTag(name, value));
    }

    public CompoundTagBuilder stringTag(String name, String value) {
        return this.tag(new StringTag(name, value));
    }

    public <T extends Tag> CompoundTagBuilder listTag(String name, Class<T> tagClass, List<T> values) {
        return this.tag(new ListTag<T>(name, tagClass, values));
    }

    public CompoundTag buildRootTag() {
        return new CompoundTag("", this.tagMap);
    }

    public CompoundTag build(String tagName) {
        return new CompoundTag(tagName, this.tagMap);
    }
}

