/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2LongFunction;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2LongMap;
import it.unimi.dsi.fastutil.doubles.Double2LongMaps;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterators;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSpliterator;
import it.unimi.dsi.fastutil.longs.LongSpliterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterators;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.DoubleConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;

public abstract class AbstractDouble2LongMap
extends AbstractDouble2LongFunction
implements Double2LongMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2LongMap() {
    }

    @Override
    public boolean containsKey(double k) {
        ObjectIterator i = this.double2LongEntrySet().iterator();
        while (i.hasNext()) {
            if (((Double2LongMap.Entry)i.next()).getDoubleKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(long v) {
        ObjectIterator i = this.double2LongEntrySet().iterator();
        while (i.hasNext()) {
            if (((Double2LongMap.Entry)i.next()).getLongValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final long mergeLong(double key, long value, it.unimi.dsi.fastutil.longs.LongBinaryOperator remappingFunction) {
        return this.mergeLong(key, value, (LongBinaryOperator)remappingFunction);
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2LongMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2LongMap.this.size();
            }

            public void clear() {
                AbstractDouble2LongMap.this.clear();
            }

            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2LongMap.Entry> i;
                    {
                        this.i = Double2LongMaps.fastIterator(AbstractDouble2LongMap.this);
                    }

                    public double nextDouble() {
                        return ((Double2LongMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public void remove() {
                        this.i.remove();
                    }

                    public void forEachRemaining(DoubleConsumer action) {
                        this.i.forEachRemaining(entry -> action.accept(entry.getDoubleKey()));
                    }
                };
            }

            public DoubleSpliterator spliterator() {
                return DoubleSpliterators.asSpliterator((DoubleIterator)this.iterator(), (long)Size64.sizeOf((Map)AbstractDouble2LongMap.this), (int)321);
            }
        };
    }

    @Override
    public LongCollection values() {
        return new AbstractLongCollection(){

            public boolean contains(long k) {
                return AbstractDouble2LongMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2LongMap.this.size();
            }

            public void clear() {
                AbstractDouble2LongMap.this.clear();
            }

            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Double2LongMap.Entry> i;
                    {
                        this.i = Double2LongMaps.fastIterator(AbstractDouble2LongMap.this);
                    }

                    public long nextLong() {
                        return ((Double2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public void remove() {
                        this.i.remove();
                    }

                    public void forEachRemaining(LongConsumer action) {
                        this.i.forEachRemaining(entry -> action.accept(entry.getLongValue()));
                    }
                };
            }

            public LongSpliterator spliterator() {
                return LongSpliterators.asSpliterator((LongIterator)this.iterator(), (long)Size64.sizeOf((Map)AbstractDouble2LongMap.this), (int)320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Long> m) {
        if (m instanceof Double2LongMap) {
            ObjectIterator<Double2LongMap.Entry> i = Double2LongMaps.fastIterator((Double2LongMap)m);
            while (i.hasNext()) {
                Double2LongMap.Entry e = (Double2LongMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getLongValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Double, ? extends Long>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Double, ? extends Long> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Double2LongMap.Entry> i = Double2LongMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Double2LongMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.double2LongEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Double2LongMap.Entry> i = Double2LongMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2LongMap.Entry e = (Double2LongMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getLongValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Double2LongMap.Entry> {
        protected final Double2LongMap map;

        public BasicEntrySet(Double2LongMap map) {
            this.map = map;
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2LongMap.Entry) {
                Double2LongMap.Entry e = (Double2LongMap.Entry)o;
                double k = e.getDoubleKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getLongValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Long)value).longValue();
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2LongMap.Entry) {
                Double2LongMap.Entry e = (Double2LongMap.Entry)o;
                return this.map.remove(e.getDoubleKey(), e.getLongValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            long v = (Long)value;
            return this.map.remove(k, v);
        }

        public int size() {
            return this.map.size();
        }

        public ObjectSpliterator<Double2LongMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator((ObjectIterator)this.iterator(), (long)Size64.sizeOf((Map)this.map), (int)65);
        }
    }

    public static class BasicEntry
    implements Double2LongMap.Entry {
        protected double key;
        protected long value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, Long value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2LongMap.Entry) {
                Double2LongMap.Entry e = (Double2LongMap.Entry)o;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e.getDoubleKey()) && this.value == e.getLongValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && this.value == (Long)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int((double)this.key) ^ HashCommon.long2int((long)this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

