/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2FloatFunction;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.doubles.Double2FloatMaps;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDouble2FloatMap
extends AbstractDouble2FloatFunction
implements Double2FloatMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2FloatMap() {
    }

    @Override
    public boolean containsValue(float v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(double k) {
        ObjectIterator i = this.double2FloatEntrySet().iterator();
        while (i.hasNext()) {
            if (((Double2FloatMap.Entry)i.next()).getDoubleKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            public boolean contains(double k) {
                return AbstractDouble2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractDouble2FloatMap.this.size();
            }

            public void clear() {
                AbstractDouble2FloatMap.this.clear();
            }

            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2FloatMap.Entry> i;
                    {
                        this.i = Double2FloatMaps.fastIterator(AbstractDouble2FloatMap.this);
                    }

                    public double nextDouble() {
                        return ((Double2FloatMap.Entry)this.i.next()).getDoubleKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractDouble2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractDouble2FloatMap.this.size();
            }

            public void clear() {
                AbstractDouble2FloatMap.this.clear();
            }

            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Double2FloatMap.Entry> i;
                    {
                        this.i = Double2FloatMaps.fastIterator(AbstractDouble2FloatMap.this);
                    }

                    public float nextFloat() {
                        return ((Double2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Float> m) {
        if (m instanceof Double2FloatMap) {
            ObjectIterator<Double2FloatMap.Entry> i = Double2FloatMaps.fastIterator((Double2FloatMap)m);
            while (i.hasNext()) {
                Double2FloatMap.Entry e = (Double2FloatMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getFloatValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Double, ? extends Float>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Double, ? extends Float> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Double2FloatMap.Entry> i = Double2FloatMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Double2FloatMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.double2FloatEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Double2FloatMap.Entry> i = Double2FloatMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2FloatMap.Entry e = (Double2FloatMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Double2FloatMap.Entry> {
        protected final Double2FloatMap map;

        public BasicEntrySet(Double2FloatMap map) {
            this.map = map;
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2FloatMap.Entry) {
                Double2FloatMap.Entry e = (Double2FloatMap.Entry)o;
                double k = e.getDoubleKey();
                return this.map.containsKey(k) && Float.floatToIntBits(this.map.get(k)) == Float.floatToIntBits(e.getFloatValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return this.map.containsKey(k) && Float.floatToIntBits(this.map.get(k)) == Float.floatToIntBits(((Float)value).floatValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2FloatMap.Entry) {
                Double2FloatMap.Entry e = (Double2FloatMap.Entry)o;
                return this.map.remove(e.getDoubleKey(), e.getFloatValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            float v = ((Float)value).floatValue();
            return this.map.remove(k, v);
        }

        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Double2FloatMap.Entry {
        protected double key;
        protected float value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, Float value) {
            this.key = key;
            this.value = value.floatValue();
        }

        public BasicEntry(double key, float value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public float getFloatValue() {
            return this.value;
        }

        @Override
        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2FloatMap.Entry) {
                Double2FloatMap.Entry e = (Double2FloatMap.Entry)o;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e.getDoubleKey()) && Float.floatToIntBits(this.value) == Float.floatToIntBits(e.getFloatValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int((double)this.key) ^ HashCommon.float2int((float)this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

