/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.log4j2;

import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.backend.SimpleMessageFormatter;
import java.util.logging.Level;

final class Log4j2LogDataFormatter {
    private Log4j2LogDataFormatter() {
    }

    static void format(LogData logData, SimpleMessageFormatter.SimpleLogHandler receiver) {
        SimpleMessageFormatter.format((LogData)logData, (SimpleMessageFormatter.SimpleLogHandler)receiver);
    }

    static void formatBadLogData(RuntimeException error, LogData badLogData, SimpleMessageFormatter.SimpleLogHandler receiver) {
        StringBuilder errorMsg = new StringBuilder("LOGGING ERROR: ").append(error.getMessage()).append('\n');
        int length = errorMsg.length();
        try {
            Log4j2LogDataFormatter.appendLogData(badLogData, errorMsg);
        }
        catch (RuntimeException e) {
            errorMsg.setLength(length);
            errorMsg.append("Cannot append LogData: ").append(e);
        }
        Level level = badLogData.getLevel().intValue() < Level.WARNING.intValue() ? Level.WARNING : badLogData.getLevel();
        receiver.handleFormattedLogMessage(level, errorMsg.toString(), (Throwable)error);
    }

    static void appendLogData(LogData data, StringBuilder out) {
        out.append("  original message: ");
        if (data.getTemplateContext() == null) {
            out.append(data.getLiteralArgument());
        } else {
            out.append(data.getTemplateContext().getMessage());
            out.append("\n  original arguments:");
            for (Object arg : data.getArguments()) {
                out.append("\n    ").append(SimpleMessageFormatter.safeToString((Object)arg));
            }
        }
        Metadata metadata = data.getMetadata();
        if (metadata.size() > 0) {
            out.append("\n  metadata:");
            for (int n = 0; n < metadata.size(); ++n) {
                out.append("\n    ");
                out.append(metadata.getKey(n).getLabel()).append(": ").append(metadata.getValue(n));
            }
        }
        out.append("\n  level: ").append(data.getLevel());
        out.append("\n  timestamp (nanos): ").append(data.getTimestampNanos());
        out.append("\n  class: ").append(data.getLogSite().getClassName());
        out.append("\n  method: ").append(data.getLogSite().getMethodName());
        out.append("\n  line number: ").append(data.getLogSite().getLineNumber());
    }
}

