/*
 * Decompiled with CFR 0.152.
 */
package com.github.suprememortal.skinchanger;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerLoginEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.PlayerSkinPacket;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.plugin.service.ServicePriority;
import com.github.suprememortal.skinchanger.ResetSkinCommand;
import com.github.suprememortal.skinchanger.SkinChangeException;
import com.github.suprememortal.skinchanger.SkinChanger;
import com.github.suprememortal.skinchanger.SkinChangerCommand;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;

public class SkinChangerPlugin
extends PluginBase
implements Listener,
SkinChanger {
    private final Map<UUID, Skin> originalSkins = new HashMap<UUID, Skin>();
    private Path pluginDir;
    private static final DirectoriesFilter DIRECTORIES_FILTER = new DirectoriesFilter();

    public void onEnable() {
        this.pluginDir = this.getDataFolder().toPath();
        if (Files.notExists(this.pluginDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.pluginDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Could not create directory");
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getCommandMap().register("skinchanger", (Command)new SkinChangerCommand(this));
        this.getServer().getCommandMap().register("skinchanger", (Command)new ResetSkinCommand(this));
        this.getServer().getServiceManager().register(SkinChanger.class, (Object)this, (Plugin)this, ServicePriority.HIGHEST);
    }

    @Override
    public void changeSkin(Player player, String name) throws SkinChangeException {
        BufferedImage skinData;
        String geometry;
        Skin skin = new Skin();
        Path skinFolderPath = this.pluginDir.resolve(name);
        Path skinGeometryPath = skinFolderPath.resolve("geometry.json");
        Path skinPath = skinFolderPath.resolve("skin.png");
        if (Files.notExists(skinFolderPath, new LinkOption[0]) || !Files.isDirectory(skinFolderPath, new LinkOption[0]) || Files.notExists(skinGeometryPath, new LinkOption[0]) || !Files.isRegularFile(skinGeometryPath, new LinkOption[0]) || Files.notExists(skinPath, new LinkOption[0]) || !Files.isRegularFile(skinPath, new LinkOption[0])) {
            throw new SkinChangeException("Skin does not exist");
        }
        try {
            geometry = new String(Files.readAllBytes(skinGeometryPath), StandardCharsets.UTF_8);
            skinData = ImageIO.read(skinPath.toFile());
        }
        catch (IOException e) {
            throw new SkinChangeException("Error loading data", e);
        }
        skin.setGeometryData(geometry);
        skin.setGeometryName("geometry." + name);
        skin.setSkinData(skinData);
        skin.setSkinId(name);
        skin.setPremium(true);
        Skin oldSkin = player.getSkin();
        player.setSkin(skin);
        PlayerSkinPacket packet = new PlayerSkinPacket();
        packet.skin = skin;
        packet.newSkinName = name;
        packet.oldSkinName = oldSkin.getSkinId();
        packet.uuid = player.getUniqueId();
        Server.broadcastPacket(Server.getInstance().getOnlinePlayers().values(), (DataPacket)packet);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLogin(PlayerLoginEvent event) {
        this.originalSkins.put(event.getPlayer().getUniqueId(), event.getPlayer().getSkin());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent event) {
        this.originalSkins.remove(event.getPlayer().getUniqueId());
    }

    @Override
    public boolean resetSkin(Player player) {
        Skin skin = this.originalSkins.get(player.getUniqueId());
        if (skin != null) {
            Skin oldSkin = player.getSkin();
            player.setSkin(skin);
            PlayerSkinPacket packet = new PlayerSkinPacket();
            packet.skin = skin;
            packet.newSkinName = skin.getSkinId();
            packet.oldSkinName = oldSkin.getSkinId();
            packet.uuid = player.getUniqueId();
            Server.broadcastPacket(Server.getInstance().getOnlinePlayers().values(), (DataPacket)packet);
            return true;
        }
        return false;
    }

    @Override
    public String[] getAvailableSkins() {
        ArrayList<String> skins = new ArrayList<String>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.pluginDir, DIRECTORIES_FILTER);){
            for (Path path : ds) {
                skins.add(path.getFileName().toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return skins.toArray(new String[0]);
    }

    private static class DirectoriesFilter
    implements DirectoryStream.Filter<Path> {
        private DirectoriesFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    }
}

