/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.fakeinventories.inventory;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import com.google.common.base.Preconditions;
import com.nukkitx.fakeinventories.inventory.FakeInventoryListener;
import com.nukkitx.fakeinventories.inventory.FakeSlotChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FakeInventory
extends ContainerInventory {
    private static final BlockVector3 ZERO = new BlockVector3(0, 0, 0);
    static final Map<Player, FakeInventory> open = new ConcurrentHashMap<Player, FakeInventory>();
    protected final Map<Player, List<BlockVector3>> blockPositions = new HashMap<Player, List<BlockVector3>>();
    private final List<FakeInventoryListener> listeners = new CopyOnWriteArrayList<FakeInventoryListener>();
    private boolean closed = false;
    private String title;

    public FakeInventory(InventoryType type) {
        this(type, null);
    }

    public FakeInventory(InventoryType type, InventoryHolder holder) {
        this(type, holder, null);
    }

    public FakeInventory(InventoryType type, InventoryHolder holder, String title) {
        super(holder, type);
        this.title = title == null ? type.getDefaultTitle() : title;
    }

    public void onOpen(Player who) {
        this.checkForClosed();
        this.viewers.add(who);
        if (open.putIfAbsent(who, this) != null) {
            throw new IllegalStateException("Inventory was already open");
        }
        List<BlockVector3> blocks = this.onOpenBlock(who);
        this.blockPositions.put(who, blocks);
        this.onFakeOpen(who, blocks);
    }

    protected void onFakeOpen(Player who, List<BlockVector3> blocks) {
        BlockVector3 blockPosition = blocks.isEmpty() ? ZERO : blocks.get(0);
        ContainerOpenPacket containerOpen = new ContainerOpenPacket();
        containerOpen.windowId = who.getWindowId((Inventory)this);
        containerOpen.type = this.getType().getNetworkType();
        containerOpen.x = blockPosition.x;
        containerOpen.y = blockPosition.y;
        containerOpen.z = blockPosition.z;
        who.dataPacket((DataPacket)containerOpen);
        this.sendContents(who);
    }

    protected abstract List<BlockVector3> onOpenBlock(Player var1);

    public void onClose(Player who) {
        super.onClose(who);
        open.remove(who, (Object)this);
        List<BlockVector3> blocks = this.blockPositions.get(who);
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            int index = i;
            Server.getInstance().getScheduler().scheduleDelayedTask(() -> {
                Vector3 blockPosition = ((BlockVector3)blocks.get(index)).asVector3();
                UpdateBlockPacket updateBlock = new UpdateBlockPacket();
                updateBlock.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId((int)who.getLevel().getBlock(blockPosition).getFullId());
                updateBlock.flags = 11;
                updateBlock.x = blockPosition.getFloorX();
                updateBlock.y = blockPosition.getFloorY();
                updateBlock.z = blockPosition.getFloorZ();
                who.dataPacket((DataPacket)updateBlock);
            }, 2 + i, false);
        }
    }

    public List<BlockVector3> getPosition(Player player) {
        this.checkForClosed();
        return this.blockPositions.getOrDefault(player, null);
    }

    public void addListener(FakeInventoryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.checkForClosed();
        this.listeners.add(listener);
    }

    public void removeListener(FakeInventoryListener listener) {
        this.checkForClosed();
        this.listeners.remove(listener);
    }

    public boolean onSlotChange(Player source, SlotChangeAction action) {
        if (!this.listeners.isEmpty()) {
            FakeSlotChangeEvent event = new FakeSlotChangeEvent(source, this, action);
            for (FakeInventoryListener listener : this.listeners) {
                listener.onSlotChange(event);
            }
            return event.isCancelled();
        }
        return false;
    }

    private void checkForClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed");
    }

    void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed");
        this.getViewers().forEach(player -> player.removeWindow((Inventory)this));
        this.closed = true;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? this.type.getDefaultTitle() : title;
    }
}

