/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.fakeinventories.inventory;

import cn.nukkit.Player;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import com.nukkitx.fakeinventories.inventory.FakeInventory;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;

public class ChestFakeInventory
extends FakeInventory {
    private String name;

    public ChestFakeInventory() {
        this((InventoryHolder)null);
    }

    public ChestFakeInventory(InventoryHolder holder) {
        this(holder, null);
    }

    public ChestFakeInventory(InventoryHolder holder, String title) {
        super(InventoryType.CHEST, holder, title);
    }

    ChestFakeInventory(InventoryType type, InventoryHolder holder, String title) {
        super(type, holder, title);
    }

    @Override
    protected List<BlockVector3> onOpenBlock(Player who) {
        BlockVector3 blockPosition = new BlockVector3((int)who.x, (int)who.y + 2, (int)who.z);
        this.placeChest(who, blockPosition);
        return Collections.singletonList(blockPosition);
    }

    protected void placeChest(Player who, BlockVector3 pos) {
        UpdateBlockPacket updateBlock = new UpdateBlockPacket();
        updateBlock.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId((int)54, (int)0);
        updateBlock.flags = 11;
        updateBlock.x = pos.x;
        updateBlock.y = pos.y;
        updateBlock.z = pos.z;
        who.dataPacket((DataPacket)updateBlock);
        BlockEntityDataPacket blockEntityData = new BlockEntityDataPacket();
        blockEntityData.x = pos.x;
        blockEntityData.y = pos.y;
        blockEntityData.z = pos.z;
        blockEntityData.namedTag = ChestFakeInventory.getNbt(pos, this.getName());
        who.dataPacket((DataPacket)blockEntityData);
    }

    private static byte[] getNbt(BlockVector3 pos, String name) {
        CompoundTag tag = new CompoundTag().putString("id", "Chest").putInt("x", pos.x).putInt("y", pos.y).putInt("z", pos.z).putString("CustomName", name == null ? "Chest" : name);
        try {
            return NBTIO.write((CompoundTag)tag, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create NBT for chest");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

